(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     53671,       1736]
NotebookOptionsPosition[     52885,       1704]
NotebookOutlinePosition[     53276,       1721]
CellTagsIndexPosition[     53233,       1718]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{
             RowBox[{
              RowBox[{
               RowBox[{
                RowBox[{"**", "**", "**"}], "**", "**", "**"}], "**", "**", 
               "**"}], "**", "**", "**"}], "**", "**", "**"}], "**", "**", 
            "**"}], "**", "**", "**"}], "**", "**", "**"}], "**", "**", 
         "**"}], "**", "**", "**"}], "**", "**", "**"}], "**"}], "*", 
     "\[IndentingNewLine]", "*", " ", "Please", " ", "put", " ", "the", " ", 
     "data", " ", "files", " ", "and", " ", "this", " ", "notebook", " ", 
     "file", " ", "in", " ", "the", " ", "same", " ", "directory", 
     "\[IndentingNewLine]", "*", " ", "For", " ", "E6", " ", "model"}], ",", 
    " ", 
    RowBox[{
    "the", " ", "order", " ", "of", " ", "node", " ", "is", " ", "slightly", 
     " ", "different", " ", "from", " ", "it", " ", "in", " ", "our", " ", 
     RowBox[{"paper", ".", " ", "\[IndentingNewLine]", "Here"}], " ", "the", 
     " ", "order", " ", "is", " ", 
     RowBox[{"(", 
      RowBox[{
       SubscriptBox["d", "0"], ",", " ", 
       SubscriptBox["d", "2"], ",", " ", 
       SubscriptBox["d", "3"], ",", " ", 
       SubscriptBox["d", "4"], ",", " ", 
       SubscriptBox["d", "5"], ",", " ", 
       SubscriptBox["d", "6"], ",", " ", 
       SubscriptBox["d", "1"], ",", " ", 
       SubscriptBox["d", "b"]}], ")"}], "\[IndentingNewLine]", " ", "Please", 
     " ", "check", " ", "the", " ", "Cartan", " ", "matrix", " ", "before", 
     " ", 
     RowBox[{"using", ".", "\[IndentingNewLine]", 
      RowBox[{"**", "**", "**"}]}], "*", 
     RowBox[{
     "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
       "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**", "**",
       "**", "**", "**", "**", "**"}]}]}], "***)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"bpstable2", "[", "data_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"length1", "=", 
          RowBox[{"Max", "[", 
           RowBox[{"data", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", "1"}], "]"}], "]"}], "]"}]}], ",", 
         RowBox[{"length2", "=", 
          RowBox[{"Max", "[", 
           RowBox[{"data", "[", 
            RowBox[{"[", 
             RowBox[{"All", ",", "2"}], "]"}], "]"}], "]"}]}], ",", 
         RowBox[{"table", "=", 
          RowBox[{"{", "}"}]}]}], "}"}], ",", 
       RowBox[{
        RowBox[{"table", "=", 
         RowBox[{"{", 
          RowBox[{"Prepend", "[", 
           RowBox[{
            RowBox[{"Table", "[", 
             RowBox[{"i", ",", 
              RowBox[{"{", 
               RowBox[{"i", ",", "0", ",", "length2"}], "}"}]}], "]"}], ",", 
            "\"\<2\!\(\*SubscriptBox[\(j\), \
\(L\)]\)\\\\2\!\(\*SubscriptBox[\(j\), \(R\)]\)\>\""}], "]"}], "}"}]}], ";", 
        RowBox[{"Join", "[", 
         RowBox[{"table", ",", 
          RowBox[{"Table", "[", 
           RowBox[{
            RowBox[{"Prepend", "[", 
             RowBox[{
              RowBox[{"Table", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{"temp", "=", 
                  RowBox[{"Cases", "[", 
                   RowBox[{"data", ",", 
                    RowBox[{"{", 
                    RowBox[{"jl", ",", "jr", ",", "_"}], "}"}]}], "]"}]}], 
                 ";", 
                 RowBox[{"If", "[", 
                  RowBox[{
                   RowBox[{
                    RowBox[{"Length", "[", "temp", "]"}], "\[Equal]", "0"}], 
                   ",", "\"\< \>\"", ",", " ", 
                   RowBox[{"FullForm", "[", 
                    RowBox[{"Abs", "[", 
                    RowBox[{
                    RowBox[{"temp", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "[", 
                    RowBox[{"[", "3", "]"}], "]"}], "]"}], "]"}]}], "]"}]}], 
                ",", 
                RowBox[{"{", 
                 RowBox[{"jr", ",", "0", ",", "length2"}], "}"}]}], "]"}], 
              ",", "jl"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{"jl", ",", "0", ",", "length1"}], "}"}]}], "]"}]}], 
         "]"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"GetData2", "[", "n_", "]"}], ":=", 
     RowBox[{"Module", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"$return", ",", "$directory"}], "}"}], ",", 
       RowBox[{
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"MemberQ", "[", 
           RowBox[{
            RowBox[{"{", 
             RowBox[{"3", ",", "4", ",", "5", ",", "6", ",", "8", ",", "12"}],
              "}"}], ",", "n"}], "]"}], ",", 
          RowBox[{
           RowBox[{"$directory", "=", 
            RowBox[{
             RowBox[{"NotebookDirectory", "[", "]"}], "<>", "\"\<dlist_n\>\"",
              "<>", 
             RowBox[{"ToString", "[", "n", "]"}]}]}], ";", 
           RowBox[{"$return", "=", 
            RowBox[{"Get", "[", "$directory", "]"}]}], ";", 
           RowBox[{"If", "[", 
            RowBox[{
             RowBox[{"$return", "===", "$Failed"}], ",", 
             RowBox[{"Print", "[", 
              RowBox[{
              "\"\<File do not exist in the directory:\>\"", "<>", 
               "$directory"}], "]"}], ",", 
             RowBox[{"Return", "[", "True", "]"}]}], "]"}]}], ",", 
          RowBox[{
           RowBox[{"Print", "[", "\"\<Model do not exist\>\"", "]"}], ";"}]}],
          "]"}], ";", 
        RowBox[{"Return", "[", "False", "]"}]}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"GetData", "[", "n_", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", "$return", "}"}], ",", 
      RowBox[{
       RowBox[{"Clear", "[", 
        RowBox[{
        "dlist4", ",", "Cmatrix", ",", "$totaldegree", ",", 
         "degreelistListByTotalDegree", ",", "degreelistListByBaseDegree"}], 
        "]"}], ";", 
       RowBox[{"$return", "=", 
        RowBox[{"GetData2", "[", "n", "]"}]}], ";", 
       RowBox[{"If", "[", 
        RowBox[{"$return", ",", 
         RowBox[{
          RowBox[{"Print", "[", 
           RowBox[{"\"\<Get BPS data up to total degree \>\"", "<>", 
            RowBox[{"ToString", "[", "$totaldegree", "]"}], "<>", 
            "\"\< for minimal string n=\>\"", "<>", 
            RowBox[{"ToString", "[", "n", "]"}], "<>", 
            "\"\< successfully.\>\""}], "]"}], ";", 
          RowBox[{"Print", "[", 
           RowBox[{"\"\<Cartan matrix:\>\"", ",", 
            RowBox[{"MatrixForm", "[", "Cmatrix", "]"}]}], "]"}], ";", 
          RowBox[{
          "Print", "[", 
           "\"\<The degrees of non-zero BPS invariants are stored in \
degreelistListByTotalDegree[n], where n is the total degree.\>\"", "]"}]}], 
         ",", 
         RowBox[{"Print", "[", "\"\<Failed\>\"", "]"}]}], "]"}]}]}], "]"}]}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"PrintDegree", "[", "degree_", "]"}], ":=", 
    RowBox[{"Grid", "[", 
     RowBox[{
      RowBox[{"bpstable2", "[", 
       RowBox[{"dlist4", "[", 
        RowBox[{"Sequence", "@@", " ", "degree"}], "]"}], "]"}], ",", 
      RowBox[{"Dividers", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"2", "\[Rule]", "True"}], ",", 
         RowBox[{"2", "\[Rule]", "True"}]}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}]}], "]"}]}]}]}]], "Input",
 CellChangeTimes->{{3.765173600882123*^9, 3.7651736023420677`*^9}, {
  3.765173664832368*^9, 3.7651737877807713`*^9}, {3.765173839354248*^9, 
  3.7651738409439583`*^9}, {3.7651738868168592`*^9, 3.765173978618945*^9}, {
  3.7651740108961287`*^9, 3.765174135873796*^9}, {3.765174248747057*^9, 
  3.7651742606745043`*^9}, {3.765174297660347*^9, 3.7651743009737387`*^9}, {
  3.765174339133687*^9, 3.765174386086331*^9}, {3.765174487913435*^9, 
  3.76517473148228*^9}, {3.765174763380857*^9, 3.7651748127732286`*^9}, {
  3.765174888259034*^9, 3.765174955723621*^9}, {3.765175019753707*^9, 
  3.765175513573483*^9}, {3.765175582608644*^9, 3.765175616775475*^9}, {
  3.7651756551617527`*^9, 3.7651756601685457`*^9}, {3.7655596825447807`*^9, 
  3.76555975799017*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"GetData", "[", "6", "]"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
    "Get", " ", "the", " ", "data", " ", "for", " ", "model", " ", "n"}], "=",
     "6"}], "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"degree", "=", 
  RowBox[{
   RowBox[{"degreelistListByTotalDegree", "[", "8", "]"}], "[", 
   RowBox[{"[", "455", "]"}], "]"}], 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"The", " ", "degree", " ", "of", " ", "non"}], "-", 
    RowBox[{
    "vanishing", " ", "BPS", " ", "invariants", " ", "for", " ", "fix", " ", 
     "total", " ", "degree", " ", "n", " ", "are", " ", "stored", " ", "in", 
     " ", 
     RowBox[{"degreelistListByTotalDegree", "[", "n", "]"}]}]}], 
   "*)"}]}]}], "Input",
 CellChangeTimes->{{3.765174663307171*^9, 3.765174664036084*^9}, {
  3.765175675050593*^9, 3.765175705096943*^9}, {3.7651758057123947`*^9, 
  3.76517586087335*^9}, {3.765559763159087*^9, 3.765559822262987*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Get BPS data up to total degree 12 for minimal string n=6 \
successfully.\"\>"], "Print",
 CellChangeTimes->{
  3.765174928803776*^9, 3.765175086660676*^9, 3.765175139899788*^9, {
   3.765175521159902*^9, 3.765175538570743*^9}, {3.765175687070526*^9, 
   3.765175705770186*^9}, {3.765175806225281*^9, 3.765175861907895*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Cartan matrix:\"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"-", "2"}], "0", "0", "0", "0", "0", "1"},
       {"0", 
        RowBox[{"-", "2"}], "1", "0", "0", "0", "0"},
       {"0", "1", 
        RowBox[{"-", "2"}], "1", "0", "0", "0"},
       {"0", "0", "1", 
        RowBox[{"-", "2"}], "1", "0", "1"},
       {"0", "0", "0", "1", 
        RowBox[{"-", "2"}], "1", "0"},
       {"0", "0", "0", "0", "1", 
        RowBox[{"-", "2"}], "0"},
       {"1", "0", "0", "1", "0", "0", 
        RowBox[{"-", "2"}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Cartan matrix:", 
   MatrixForm[{{-2, 0, 0, 0, 0, 0, 1}, {0, -2, 1, 0, 0, 0, 0}, {0, 1, -2, 1, 
    0, 0, 0}, {0, 0, 1, -2, 1, 0, 1}, {0, 0, 0, 1, -2, 1, 0}, {0, 0, 0, 0, 
    1, -2, 0}, {1, 0, 0, 1, 0, 0, -2}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.765174928803776*^9, 3.765175086660676*^9, 3.765175139899788*^9, {
   3.765175521159902*^9, 3.765175538570743*^9}, {3.765175687070526*^9, 
   3.765175705770186*^9}, {3.765175806225281*^9, 3.7651758619253397`*^9}}],

Cell[BoxData["\<\"The degrees of non-zero BPS invariants are stored in \
degreelistListByTotalDegree[n], where n is the total degree.\"\>"], "Print",
 CellChangeTimes->{
  3.765174928803776*^9, 3.765175086660676*^9, 3.765175139899788*^9, {
   3.765175521159902*^9, 3.765175538570743*^9}, {3.765175687070526*^9, 
   3.765175705770186*^9}, {3.765175806225281*^9, 3.765175861940164*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
  "0", ",", "0", ",", "0", ",", "2", ",", "0", ",", "0", ",", "3", ",", "3"}],
   "}"}]], "Output",
 CellChangeTimes->{{3.7651756871175528`*^9, 3.765175705798277*^9}, {
  3.765175806275959*^9, 3.765175861956415*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"PrintDegree", "[", "degree", "]"}], 
  RowBox[{"(*", 
   RowBox[{
   "Print", " ", "the", " ", "table", " ", "of", " ", "invariants", " ", 
    "for", " ", "a", " ", "specific", " ", "degree"}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.765175720138468*^9, 3.765175720714251*^9}, 
   3.7651758265159597`*^9, {3.765559835199216*^9, 3.765559860808066*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"2\\!\\(\\*SubscriptBox[\\(j\\), \
\\(L\\)]\\)\\\\2\\!\\(\\*SubscriptBox[\\(j\\), \\(R\\)]\\)\"\>", "0", "1", 
     "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"},
    {"0", "\<\" \"\>", 
     TagBox[
      StyleBox["6",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["11",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["13",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["11",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["7",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["2",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>"},
    {"1", "\<\" \"\>", "\<\" \"\>", 
     TagBox[
      StyleBox["2",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["4",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["5",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["5",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["3",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["1",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm]},
    {"2", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", 
     TagBox[
      StyleBox["1",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["1",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["1",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["1",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>"}
   },
   AutoDelete->False,
   GridBoxDividers->{
    "ColumnsIndexed" -> {2 -> True}, "RowsIndexed" -> {2 -> True}},
   GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{
  3.765175721403088*^9, {3.765175827019795*^9, 3.7651758634461946`*^9}, 
   3.765175924957905*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PrintDegree", "[", 
  RowBox[{"{", 
   RowBox[{
   "0", ",", "0", ",", "1", ",", "5", ",", "0", ",", "0", ",", "1", ",", 
    "5"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.7651980529072657`*^9, 3.765198058589764*^9}}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"2\\!\\(\\*SubscriptBox[\\(j\\), \
\\(L\\)]\\)\\\\2\\!\\(\\*SubscriptBox[\\(j\\), \\(R\\)]\\)\"\>", "0", "1", 
     "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", 
     "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", 
     "27", "28", "29", "30", "31", "32", "33", "34", "35"},
    {"0", "\<\" \"\>", 
     TagBox[
      StyleBox["992",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["1980",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["3001",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["4100",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["5241",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["6249",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["6824",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["6654",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["5557",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["3777",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["2005",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["783",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["208",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["37",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["2",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\
\>", "\<\" \"\>"},
    {"1", 
     TagBox[
      StyleBox["470",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["1483",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["2690",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["4158",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["5899",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["7804",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["9553",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["10592",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["10299",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["8357",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["5332",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["2551",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["872",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["193",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["24",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["1",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\
\>"},
    {"2", "\<\" \"\>", 
     TagBox[
      StyleBox["527",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["1227",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["2253",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["3686",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["5532",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["7677",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["9776",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["11154",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["10971",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["8765",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["5308",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["2319",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["695",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["125",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["12",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\
\>", "\<\" \"\>"},
    {"3", 
     TagBox[
      StyleBox["96",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["342",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["755",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["1458",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["2558",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["4112",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["6067",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["8136",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["9660",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["9729",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["7748",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["4493",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["1791",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["470",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["69",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["4",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\
\>"},
    {"4", "\<\" \"\>", 
     TagBox[
      StyleBox["59",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["166",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["382",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["797",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["1522",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["2653",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["4203",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["5986",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["7449",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["7724",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["6157",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["3430",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["1251",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["285",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["31",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["1",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>"},
    {"5", 
     TagBox[
      StyleBox["5",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["22",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["65",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["168",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["387",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["807",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["1531",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["2624",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["4003",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["5262",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["5657",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["4543",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["2444",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["809",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["155",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["12",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\
\>"},
    {"6", "\<\" \"\>", 
     TagBox[
      StyleBox["1",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["6",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["22",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["65",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["168",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["387",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["805",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["1505",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["2481",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["3472",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["3896",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["3164",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["1638",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["485",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["77",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["4",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>"},
    {"7", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", 
     TagBox[
      StyleBox["1",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["6",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["22",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["65",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["168",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["386",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["791",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["1420",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["2135",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["2518",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["2074",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["1035",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["272",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["34",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["1",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", "\<\" \"\>", "\<\" \"\>"},
    {"8", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", \
"\<\" \"\>", "\<\" \"\>", 
     TagBox[
      StyleBox["1",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["6",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["22",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["65",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["168",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["382",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["754",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["1231",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["1541",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["1297",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["625",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["143",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["13",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>"},
    {"9", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", \
"\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", 
     TagBox[
      StyleBox["1",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["6",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["22",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["65",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["167",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["368",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["661",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["889",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["768",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["356",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["69",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["4",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", "\<\" \"\>", "\<\" \"\>"},
    {"10", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\
\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", \
"\<\" \"\>", "\<\" \"\>", 
     TagBox[
      StyleBox["1",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["6",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["22",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["65",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["163",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["328",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["480",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["429",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["191",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["30",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["1",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", "\<\" \"\>"},
    {"11", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\
\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", \
"\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", 
     TagBox[
      StyleBox["1",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["6",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["22",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["64",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["148",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["241",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["225",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["97",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["12",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", "\<\" \"\>", "\<\" \"\>"},
    {"12", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\
\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", \
"\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", \
"\<\" \"\>", "\<\" \"\>", 
     TagBox[
      StyleBox["1",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["6",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["22",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["60",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["112",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["112",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["47",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["4",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", "\<\" \"\>"},
    {"13", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\
\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", \
"\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", \
"\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", 
     TagBox[
      StyleBox["1",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["6",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["21",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["46",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["49",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["20",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["1",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>"},
    {"14", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\
\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", \
"\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", \
"\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", \
"\<\" \"\>", "\<\" \"\>", 
     TagBox[
      StyleBox["1",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["6",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["17",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["20",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["8",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", "\<\" \"\>"},
    {"15", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\
\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", \
"\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", \
"\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", \
"\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", 
     TagBox[
      StyleBox["1",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["5",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["7",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["3",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>"},
    {"16", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\
\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", \
"\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", \
"\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", \
"\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", "\<\" \"\>", \
"\<\" \"\>", "\<\" \"\>", 
     TagBox[
      StyleBox["1",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["2",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm], "\<\" \"\>", 
     TagBox[
      StyleBox["1",
       ShowSpecialCharacters->False,
       ShowStringCharacters->True,
       NumberMarks->True],
      FullForm]}
   },
   AutoDelete->False,
   GridBoxDividers->{
    "ColumnsIndexed" -> {2 -> True}, "RowsIndexed" -> {2 -> True}},
   GridBoxFrame->{"ColumnsIndexed" -> {{{1, -1}, {1, -1}} -> True}},
   GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
  "Grid"]], "Output",
 CellChangeTimes->{3.765198059609474*^9}]
}, Open  ]]
},
WindowSize->{1391, 606},
WindowMargins->{{62, Automatic}, {21, Automatic}},
Magnification:>0.75 Inherited,
FrontEndVersion->"11.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (September \
21, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 8373, 203, 325, "Input"],
Cell[CellGroupData[{
Cell[8956, 227, 944, 23, 42, "Input"],
Cell[CellGroupData[{
Cell[9925, 254, 342, 5, 18, "Print"],
Cell[10270, 261, 1623, 40, 96, "Print"],
Cell[11896, 303, 384, 5, 18, "Print"]
}, Open  ]],
Cell[12295, 311, 256, 6, 25, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12588, 322, 389, 8, 25, "Input"],
Cell[12980, 332, 3353, 113, 74, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16370, 450, 248, 6, 25, "Input"],
Cell[16621, 458, 36248, 1243, 270, "Output"]
}, Open  ]]
}
]
*)

