(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    295332,       7935]
NotebookOptionsPosition[    289641,       7851]
NotebookOutlinePosition[    289980,       7866]
CellTagsIndexPosition[    289937,       7863]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Supplementary Material", "Title",
 CellChangeTimes->{{3.80569694386724*^9, 
  3.805696958245504*^9}},ExpressionUUID->"7888f489-cae6-43e0-8513-\
38c113cc070b"],

Cell[CellGroupData[{

Cell["Equal Mass Picard-Fuchs Equations", "Chapter",
 CellChangeTimes->{{3.8056969615753717`*^9, 
  3.805696976324519*^9}},ExpressionUUID->"9ce23d2b-debd-491c-a3d5-\
7fe6dd1307b3"],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"LT", "[", 
    RowBox[{"z_", ",", "0"}], "]"}], ":=", 
   RowBox[{"f", "[", "z", "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LT", "[", 
    RowBox[{"z_", ",", "1"}], "]"}], ":=", 
   RowBox[{"z", " ", 
    RowBox[{"D", "[", 
     RowBox[{
      RowBox[{"f", "[", "z", "]"}], ",", "z"}], "]"}]}]}], " ", 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"LT", "[", 
    RowBox[{"z_", ",", "k_"}], "]"}], ":=", 
   RowBox[{"Expand", "[", 
    RowBox[{
     RowBox[{"z", " ", 
      RowBox[{"D", "[", 
       RowBox[{
        RowBox[{"LT", "[", 
         RowBox[{"z", ",", 
          RowBox[{"k", "-", "1"}]}], "]"}], ",", "z"}], "]"}]}], "-", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{"z", " ", "kk", 
         RowBox[{"(", 
          RowBox[{"n", "-", "kk", "+", "1"}], ")"}]}], "/.", 
        RowBox[{"kk", "\[Rule]", 
         RowBox[{"k", "-", "1"}]}]}], ")"}], 
      RowBox[{"LT", "[", 
       RowBox[{"z", ",", 
        RowBox[{"k", "-", "2"}]}], "]"}]}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"L", "[", 
    RowBox[{"z_", ",", "k_"}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{
      RowBox[{"LT", "[", 
       RowBox[{"z", ",", "k"}], "]"}], "/.", 
      RowBox[{"n", "\[Rule]", 
       RowBox[{"k", "-", "1"}]}]}], "/.", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{"f", "[", "z", "]"}], ",", 
          RowBox[{"{", 
           RowBox[{"z", ",", "nn"}], "}"}]}], "]"}], "\[Rule]", 
        RowBox[{
         FractionBox["1", 
          SuperscriptBox["z", "nn"]], 
         RowBox[{"Product", "[", 
          RowBox[{
           RowBox[{"\[Theta]", "-", "i"}], ",", 
           RowBox[{"{", 
            RowBox[{"i", ",", "0", ",", 
             RowBox[{"nn", "-", "1"}]}], "}"}]}], "]"}]}]}], ",", 
       RowBox[{"{", 
        RowBox[{"nn", ",", "0", ",", "k"}], "}"}]}], "]"}]}], "//", 
    RowBox[{
     RowBox[{"Collect", "[", 
      RowBox[{"#", ",", "\[Theta]", ",", "Expand"}], "]"}], "&"}]}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"PFOperators", "[", 
    RowBox[{"z_", ",", "l_"}], "]"}], ":=", 
   RowBox[{"Module", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"hi", ",", "max", ",", "ersetzen"}], "}"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"hi", "=", 
       RowBox[{
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"-", "1"}], ")"}], "l"], 
        RowBox[{"L", "[", 
         RowBox[{"z", ",", 
          RowBox[{"l", "+", "2"}]}], "]"}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"max", "=", 
       RowBox[{"Exponent", "[", 
        RowBox[{"hi", ",", "z", ",", "Max"}], "]"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"ersetzen", "=", 
       RowBox[{
        RowBox[{"Table", "[", 
         RowBox[{
          RowBox[{
           SuperscriptBox["z", "n"], "\[Rule]", 
           RowBox[{"\[Theta]", 
            RowBox[{"(", 
             RowBox[{"z", "*", 
              SuperscriptBox["z", 
               RowBox[{"n", "-", "1"}]], 
              RowBox[{"Product", "[", 
               RowBox[{
                RowBox[{"\[Theta]", "+", "i"}], ",", 
                RowBox[{"{", 
                 RowBox[{"i", ",", "1", ",", 
                  RowBox[{"n", "-", "1"}]}], "}"}]}], "]"}]}], ")"}]}]}], ",", 
          RowBox[{"{", 
           RowBox[{"n", ",", "0", ",", "max"}], "}"}]}], "]"}], "//", 
        "Expand"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"hi", "=", 
       RowBox[{"hi", "/.", "ersetzen"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"hi", "=", 
       RowBox[{
        RowBox[{"hi", "/", "\[Theta]"}], "//", "Expand"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"hi", "=", 
       RowBox[{"hi", "/.", "ersetzen"}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"hi", "=", 
       RowBox[{
        RowBox[{"hi", "/", "\[Theta]"}], "//", "Expand"}]}], ";", 
      "\[IndentingNewLine]", 
      RowBox[{"hi", "=", 
       RowBox[{"hi", "/.", 
        RowBox[{"\[Theta]", "\[Rule]", 
         RowBox[{"\[Theta]", "-", "1"}]}]}]}], ";", "\[IndentingNewLine]", 
      RowBox[{"Collect", "[", 
       RowBox[{"hi", ",", "\[Theta]", ",", "Factor"}], "]"}]}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.802434703337104*^9, 3.802434725860183*^9}, {
   3.802434837982869*^9, 3.8024349218290787`*^9}, {3.802436386271434*^9, 
   3.802436395236683*^9}, {3.8024364395196667`*^9, 3.802436439786941*^9}, {
   3.80243649211263*^9, 3.802436527609825*^9}, {3.802436750149076*^9, 
   3.802436750360536*^9}, {3.802436900204418*^9, 3.802436932862007*^9}, {
   3.802437031022194*^9, 3.80243704421642*^9}, {3.802437085337369*^9, 
   3.8024371832480707`*^9}, 3.802437363310473*^9, {3.802437505096712*^9, 
   3.802437546641892*^9}, {3.802437631064384*^9, 3.802437659289914*^9}, 
   3.802507634904542*^9, {3.802508990116068*^9, 3.8025090231223297`*^9}, {
   3.802510014403426*^9, 3.8025100297802258`*^9}, {3.802510070811742*^9, 
   3.802510137447118*^9}, {3.805697173969654*^9, 3.805697184219666*^9}},
 CellLabel->
  "In[2659]:=",ExpressionUUID->"519c90cb-3db6-4cf6-96ec-ff3ee8c3f80d"],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{
  3.805697194719277*^9},ExpressionUUID->"6935a0df-c193-4737-b90b-\
6d1ec7269a98"],

Cell["\<\
The command PFOperators[z,k] give the equal mass Picard-Fuchs operators for \
the l-loop case in the variable z.\
\>", "Text",
 CellChangeTimes->{{3.8056972138048067`*^9, 
  3.80569728159846*^9}},ExpressionUUID->"65703c52-355b-43b4-ab7a-\
cd686257340b"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"PFOperators", "[", 
  RowBox[{"z", ",", "4"}], "]"}]], "Input",
 CellChangeTimes->{
  3.805697256600514*^9, {3.805697296943388*^9, 3.805697297247526*^9}},
 CellLabel->
  "In[2666]:=",ExpressionUUID->"78015ec6-a15d-4677-b8ae-d3cf75a7b012"],

Cell[BoxData[
 RowBox[{"1", "-", 
  RowBox[{"5", " ", "z"}], "+", 
  RowBox[{"4", " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"7", " ", "z"}]}], ")"}], " ", "\[Theta]"}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"6", "-", 
     RowBox[{"63", " ", "z"}], "+", 
     RowBox[{"26", " ", 
      SuperscriptBox["z", "2"]}], "-", 
     RowBox[{"225", " ", 
      SuperscriptBox["z", "3"]}]}], ")"}], " ", 
   SuperscriptBox["\[Theta]", "2"]}], "-", 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"2", "-", 
     RowBox[{"35", " ", "z"}], "+", 
     RowBox[{"225", " ", 
      SuperscriptBox["z", "3"]}]}], ")"}], " ", 
   SuperscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", "z"}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"9", " ", "z"}]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "1"}], "+", 
     RowBox[{"25", " ", "z"}]}], ")"}], " ", 
   SuperscriptBox["\[Theta]", "4"]}]}]], "Output",
 CellChangeTimes->{3.8056972975115957`*^9},
 CellLabel->
  "Out[2666]=",ExpressionUUID->"95bea629-39e5-4664-b677-889c7e1de93f"]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{
  3.8056973005611773`*^9},ExpressionUUID->"45cc5dfd-05ca-4417-85f7-\
15fc49bcaf2d"],

Cell["Table of Picard-Fuchs operator l<20.", "Text",
 CellChangeTimes->{{3.805697304503839*^9, 
  3.80569733702805*^9}},ExpressionUUID->"bf9f8182-e047-4d1a-8df6-\
d369dcaaa1d9"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Table", "[", 
   RowBox[{
    RowBox[{"PFOperators", "[", 
     RowBox[{"z", ",", "l"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"l", ",", "1", ",", "20"}], "}"}]}], "]"}], "//", 
  "TableForm"}]], "Input",
 CellChangeTimes->{{3.8056972578286047`*^9, 3.80569725881678*^9}},
 CellLabel->
  "In[2665]:=",ExpressionUUID->"7c9832c0-a5ee-49a4-abf0-b213c684077e"],

Cell[BoxData[
 TagBox[
  TagBox[GridBox[{
     {
      RowBox[{"1", "-", 
       RowBox[{"2", " ", "z"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"4", " ", "z"}]}], ")"}], " ", "\[Theta]"}]}]},
     {
      RowBox[{"1", "-", 
       RowBox[{"3", " ", "z"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"5", " ", "z"}]}], ")"}], " ", "\[Theta]"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "z"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"9", " ", "z"}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "2"]}]}]},
     {
      RowBox[{"1", "-", 
       RowBox[{"4", " ", "z"}], "+", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"6", " ", "z"}]}], ")"}], " ", "\[Theta]"}], "-", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"10", " ", "z"}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "2"]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"4", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"16", " ", "z"}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "3"]}]}]},
     {
      RowBox[{"1", "-", 
       RowBox[{"5", " ", "z"}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"7", " ", "z"}]}], ")"}], " ", "\[Theta]"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"6", "-", 
          RowBox[{"63", " ", "z"}], "+", 
          RowBox[{"26", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"225", " ", 
           SuperscriptBox["z", "3"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "2"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"2", "-", 
          RowBox[{"35", " ", "z"}], "+", 
          RowBox[{"225", " ", 
           SuperscriptBox["z", "3"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "3"]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "z"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"9", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"25", " ", "z"}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "4"]}]}]},
     {
      RowBox[{"1", "-", 
       RowBox[{"6", " ", "z"}], "+", 
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"8", " ", "z"}]}], ")"}], " ", "\[Theta]"}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"4", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "5"}], "+", 
          RowBox[{"36", " ", "z"}], "+", 
          RowBox[{"144", " ", 
           SuperscriptBox["z", "2"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "2"]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "5"}], "+", 
          RowBox[{"84", " ", "z"}], "-", 
          RowBox[{"118", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"2304", " ", 
           SuperscriptBox["z", "3"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "3"]}], "+", 
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"28", " ", "z"}], "+", 
          RowBox[{"1152", " ", 
           SuperscriptBox["z", "3"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "4"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"4", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"16", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"36", " ", "z"}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "5"]}]}]},
     {
      RowBox[{"1", "-", 
       RowBox[{"7", " ", "z"}], "+", 
       RowBox[{"6", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"9", " ", "z"}]}], ")"}], " ", "\[Theta]"}], "+", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"5", "-", 
          RowBox[{"60", " ", "z"}], "+", 
          RowBox[{"17", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"1726", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"14700", " ", 
           SuperscriptBox["z", "4"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "2"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "5"}], "+", 
          RowBox[{"84", " ", "z"}], "-", 
          RowBox[{"5818", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"33075", " ", 
           SuperscriptBox["z", "4"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "3"]}], "+", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"5", "-", 
          RowBox[{"126", " ", "z"}], "+", 
          RowBox[{"396", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"14642", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"47775", " ", 
           SuperscriptBox["z", "4"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "4"]}], "+", 
       RowBox[{"6", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"42", " ", "z"}], "-", 
          RowBox[{"6458", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"11025", " ", 
           SuperscriptBox["z", "4"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "5"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "z"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"9", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"25", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"49", " ", "z"}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "6"]}]}]},
     {
      RowBox[{"1", "-", 
       RowBox[{"8", " ", "z"}], "+", 
       RowBox[{"7", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"10", " ", "z"}]}], ")"}], " ", "\[Theta]"}], "-", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "7"}], "+", 
          RowBox[{"90", " ", "z"}], "-", 
          RowBox[{"6144", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"196608", " ", 
           SuperscriptBox["z", "4"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "35"}], "+", 
          RowBox[{"600", " ", "z"}], "-", 
          RowBox[{"564", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"99968", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"2359296", " ", 
           SuperscriptBox["z", "4"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "3"]}], "-", 
       RowBox[{"5", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "7"}], "+", 
          RowBox[{"168", " ", "z"}], "-", 
          RowBox[{"44672", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"737280", " ", 
           SuperscriptBox["z", "4"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "4"]}], "-", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"7", "-", 
          RowBox[{"252", " ", "z"}], "+", 
          RowBox[{"1460", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"91008", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"933888", " ", 
           SuperscriptBox["z", "4"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "5"]}], "-", 
       RowBox[{"7", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"60", " ", "z"}], "-", 
          RowBox[{"26240", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"147456", " ", 
           SuperscriptBox["z", "4"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "6"]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"4", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"16", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"36", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"64", " ", "z"}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "7"]}]}]},
     {
      RowBox[{"1", "-", 
       RowBox[{"9", " ", "z"}], "+", 
       RowBox[{"8", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"11", " ", "z"}]}], ")"}], " ", "\[Theta]"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"28", "-", 
          RowBox[{"385", " ", "z"}], "+", 
          RowBox[{"84", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"60519", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"5080860", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"32148900", " ", 
           SuperscriptBox["z", "5"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "2"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"28", "-", 
          RowBox[{"495", " ", "z"}], "+", 
          RowBox[{"181871", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"11850174", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"58939650", " ", 
           SuperscriptBox["z", "5"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "3"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"70", "-", 
          RowBox[{"1650", " ", "z"}], "+", 
          RowBox[{"3399", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"961441", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"46114983", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"172353825", " ", 
           SuperscriptBox["z", "5"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "4"]}], "-", 
       RowBox[{"8", " ", 
        RowBox[{"(", 
         RowBox[{"7", "-", 
          RowBox[{"231", " ", "z"}], "+", 
          RowBox[{"177419", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"5974461", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"16074450", " ", 
           SuperscriptBox["z", "5"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "5"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "14"}], "+", 
          RowBox[{"693", " ", "z"}], "-", 
          RowBox[{"6600", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"639782", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"13850370", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"25897725", " ", 
           SuperscriptBox["z", "5"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "6"]}], "-", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"2", "-", 
          RowBox[{"165", " ", "z"}], "+", 
          RowBox[{"172810", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"2114442", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"2679075", " ", 
           SuperscriptBox["z", "5"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "7"]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "z"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"9", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"25", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"49", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"81", " ", "z"}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "8"]}]}]},
     {
      RowBox[{"1", "-", 
       RowBox[{"10", " ", "z"}], "+", 
       RowBox[{"9", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"12", " ", "z"}]}], ")"}], " ", "\[Theta]"}], "+", 
       RowBox[{"12", " ", 
        RowBox[{"(", 
         RowBox[{"3", "-", 
          RowBox[{"44", " ", "z"}], "+", 
          RowBox[{"15228", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"2884864", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"66355200", " ", 
           SuperscriptBox["z", "5"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "2"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "21"}], "+", 
          RowBox[{"385", " ", "z"}], "-", 
          RowBox[{"274", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"305474", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"45409280", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"862617600", " ", 
           SuperscriptBox["z", "5"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "3"]}], "+", 
       RowBox[{"6", " ", 
        RowBox[{"(", 
         RowBox[{"21", "-", 
          RowBox[{"495", " ", "z"}], "+", 
          RowBox[{"602180", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"68433536", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"1035878400", " ", 
           SuperscriptBox["z", "5"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "4"]}], "+", 
       RowBox[{"6", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "21"}], "+", 
          RowBox[{"660", " ", "z"}], "-", 
          RowBox[{"2464", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"1041980", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"86756224", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"1005158400", " ", 
           SuperscriptBox["z", "5"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "5"]}], "+", 
       RowBox[{"84", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"44", " ", "z"}], "+", 
          RowBox[{"81686", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"4767808", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"40550400", " ", 
           SuperscriptBox["z", "5"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "6"]}], "+", 
       RowBox[{"36", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"66", " ", "z"}], "-", 
          RowBox[{"957", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"136004", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"5186240", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"31129600", " ", 
           SuperscriptBox["z", "5"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "7"]}], "+", 
       RowBox[{"9", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"110", " ", "z"}], "+", 
          RowBox[{"244640", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"5395456", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"22118400", " ", 
           SuperscriptBox["z", "5"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "8"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"4", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"16", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"36", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"64", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"100", " ", "z"}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "9"]}]}]},
     {
      RowBox[{"1", "-", 
       RowBox[{"11", " ", "z"}], "+", 
       RowBox[{"10", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"13", " ", "z"}]}], ")"}], " ", "\[Theta]"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"45", "-", 
          RowBox[{"702", " ", "z"}], "+", 
          RowBox[{"125", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"525432", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"203873064", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"11603076660", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"62240270400", " ", 
           SuperscriptBox["z", "6"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "2"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "30"}], "+", 
          RowBox[{"572", " ", "z"}], "-", 
          RowBox[{"954277", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"293825162", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"14114206287", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"64833615000", " ", 
           SuperscriptBox["z", "6"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "3"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"210", "-", 
          RowBox[{"5005", " ", "z"}], "+", 
          RowBox[{"7696", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"12540734", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"2986948250", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"117854226117", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"451674184500", " ", 
           SuperscriptBox["z", "6"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "4"]}], "+", 
       RowBox[{"6", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "42"}], "+", 
          RowBox[{"1287", " ", "z"}], "-", 
          RowBox[{"4066660", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"731533216", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"23000171211", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"71677163250", " ", 
           SuperscriptBox["z", "6"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "5"]}], "+", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"70", "-", 
          RowBox[{"2860", " ", "z"}], "+", 
          RowBox[{"17303", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"10413468", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"1365688280", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"33068108160", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"81870448275", " ", 
           SuperscriptBox["z", "6"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "6"]}], "+", 
       RowBox[{"24", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "5"}], "+", 
          RowBox[{"286", " ", "z"}], "-", 
          RowBox[{"1133990", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"104033241", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"1867975992", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"3601867500", " ", 
           SuperscriptBox["z", "6"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "7"]}], "+", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"15", "-", 
          RowBox[{"1287", " ", "z"}], "+", 
          RowBox[{"26884", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"5355350", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"323705551", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"4143694563", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"6123174750", " ", 
           SuperscriptBox["z", "6"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "8"]}], "+", 
       RowBox[{"10", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"143", " ", "z"}], "-", 
          RowBox[{"617474", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"21967231", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"193225149", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"216112050", " ", 
           SuperscriptBox["z", "6"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "9"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "z"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"9", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"25", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"49", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"81", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"121", " ", "z"}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "10"]}]}]},
     {
      RowBox[{"1", "-", 
       RowBox[{"12", " ", "z"}], "+", 
       RowBox[{"11", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"14", " ", "z"}]}], ")"}], " ", "\[Theta]"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"55", "-", 
          RowBox[{"910", " ", "z"}], "+", 
          RowBox[{"1446912", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"1084575744", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"128500826112", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"2446118092800", " ", 
           SuperscriptBox["z", "6"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "165"}], "+", 
          RowBox[{"3276", " ", "z"}], "-", 
          RowBox[{"1880", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"11367248", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"6772641792", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"685090897920", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"11415217766400", " ", 
           SuperscriptBox["z", "6"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "3"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "165"}], "+", 
          RowBox[{"4004", " ", "z"}], "-", 
          RowBox[{"20350204", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"9473375744", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"800769466368", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"11423711232000", " ", 
           SuperscriptBox["z", "6"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "4"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"231", "-", 
          RowBox[{"7007", " ", "z"}], "+", 
          RowBox[{"19292", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"43970224", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"15651586048", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"1079812067328", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"12888834048000", " ", 
           SuperscriptBox["z", "6"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "5"]}], "-", 
       RowBox[{"42", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "11"}], "+", 
          RowBox[{"429", " ", "z"}], "-", 
          RowBox[{"3023072", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"805036288", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"44161929216", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"431043379200", " ", 
           SuperscriptBox["z", "6"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "6"]}], "-", 
       RowBox[{"6", " ", 
        RowBox[{"(", 
         RowBox[{"55", "-", 
          RowBox[{"2860", " ", "z"}], "+", 
          RowBox[{"26026", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"21451248", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"4146055424", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"175549464576", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"1370633011200", " ", 
           SuperscriptBox["z", "6"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "7"]}], "-", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "55"}], "+", 
          RowBox[{"4004", " ", "z"}], "-", 
          RowBox[{"30934904", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"4174503424", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"131837165568", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"806879232000", " ", 
           SuperscriptBox["z", "6"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "8"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "55"}], "+", 
          RowBox[{"6006", " ", "z"}], "-", 
          RowBox[{"173316", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"46714096", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"4172732928", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"94611677184", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"445906944000", " ", 
           SuperscriptBox["z", "6"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "9"]}], "-", 
       RowBox[{"11", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"182", " ", "z"}], "-", 
          RowBox[{"1423136", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"75851776", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"1187536896", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"4246732800", " ", 
           SuperscriptBox["z", "6"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "10"]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"4", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"16", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"36", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"64", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"100", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"144", " ", "z"}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "11"]}]}]},
     {
      RowBox[{"1", "-", 
       RowBox[{"13", " ", "z"}], "+", 
       RowBox[{"12", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"15", " ", "z"}]}], ")"}], " ", "\[Theta]"}], "-", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "22"}], "+", 
          RowBox[{"385", " ", "z"}], "-", 
          RowBox[{"58", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"1287023", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"1784396440", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"398309020920", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"18073798977024", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"87655047480000", " ", 
           SuperscriptBox["z", "7"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "2"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"110", "-", 
          RowBox[{"2275", " ", "z"}], "+", 
          RowBox[{"16244413", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"17921633108", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"3437518516956", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"138164802686208", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"600437075238000", " ", 
           SuperscriptBox["z", "7"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "3"]}], "-", 
       RowBox[{"9", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "55"}], "+", 
          RowBox[{"1365", " ", "z"}], "-", 
          RowBox[{"1675", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"13990893", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"12093995330", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"1958362477902", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"68457011529696", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"261901919178900", " ", 
           SuperscriptBox["z", "7"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "4"]}], "-", 
       RowBox[{"12", " ", 
        RowBox[{"(", 
         RowBox[{"66", "-", 
          RowBox[{"2002", " ", "z"}], "+", 
          RowBox[{"24758571", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"16517041334", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"2215776047352", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"66080321844420", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"218681081994375", " ", 
           SuperscriptBox["z", "7"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "5"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"924", "-", 
          RowBox[{"35035", " ", "z"}], "+", 
          RowBox[{"154700", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"476276487", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"240712797268", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"26208814730105", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"653717020792356", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"1840847304421125", " ", 
           SuperscriptBox["z", "7"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "6"]}], "-", 
       RowBox[{"18", " ", 
        RowBox[{"(", 
         RowBox[{"44", "-", 
          RowBox[{"2145", " ", "z"}], "+", 
          RowBox[{"30296357", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"11369732948", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"981901888249", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"20072104522616", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"47388510043875", " ", 
           SuperscriptBox["z", "7"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "7"]}], "-", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "165"}], "+", 
          RowBox[{"10725", " ", "z"}], "-", 
          RowBox[{"139139", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"152298783", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"41320740027", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"2756320036787", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"45247208854269", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"88403767677225", " ", 
           SuperscriptBox["z", "7"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "8"]}], "-", 
       RowBox[{"20", " ", 
        RowBox[{"(", 
         RowBox[{"11", "-", 
          RowBox[{"1001", " ", "z"}], "+", 
          RowBox[{"14036308", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"2654635165", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"132555293343", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"1713112991118", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"2739220233750", " ", 
           SuperscriptBox["z", "7"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "9"]}], "-", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "22"}], "+", 
          RowBox[{"3003", " ", "z"}], "-", 
          RowBox[{"115830", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"41054299", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"5152967274", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"185675664273", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"1854552246474", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"2404426649625", " ", 
           SuperscriptBox["z", "7"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "10"]}], "-", 
       RowBox[{"6", " ", 
        RowBox[{"(", 
         RowBox[{"2", "-", 
          RowBox[{"455", " ", "z"}], "+", 
          RowBox[{"6092515", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"461346886", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"11523836415", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"87512357916", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"91307341125", " ", 
           SuperscriptBox["z", "7"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "11"]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "z"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"9", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"25", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"49", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"81", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"121", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"169", " ", "z"}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "12"]}]}]},
     {
      RowBox[{"1", "-", 
       RowBox[{"14", " ", "z"}], "+", 
       RowBox[{"13", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"16", " ", "z"}]}], ")"}], " ", "\[Theta]"}], "+", 
       RowBox[{"6", " ", 
        RowBox[{"(", 
         RowBox[{"13", "-", 
          RowBox[{"240", " ", "z"}], "+", 
          RowBox[{"1671792", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"4156918528", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"1637672030208", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"148211399393280", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"2497078886400000", " ", 
           SuperscriptBox["z", "7"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "2"]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "143"}], "+", 
          RowBox[{"3080", " ", "z"}], "-", 
          RowBox[{"1482", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"44990024", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"88867365440", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"30189704398848", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"2437366935453696", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"37206475407360000", " ", 
           SuperscriptBox["z", "7"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "3"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"715", "-", 
          RowBox[{"18200", " ", "z"}], "+", 
          RowBox[{"374123024", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"579966960832", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"167374106867712", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"11869686056484864", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"161665048903680000", " ", 
           SuperscriptBox["z", "7"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "4"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1287"}], "+", 
          RowBox[{"39312", " ", "z"}], "-", 
          RowBox[{"85600", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"956237424", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"1148110054560", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"277122997353472", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"16986870932373504", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"203231424046694400", " ", 
           SuperscriptBox["z", "7"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "5"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"429", "-", 
          RowBox[{"16016", " ", "z"}], "+", 
          RowBox[{"419053812", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"384507988732", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"76348939263744", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"3978060800532480", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"41171888701440000", " ", 
           SuperscriptBox["z", "7"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "6"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "429"}], "+", 
          RowBox[{"20020", " ", "z"}], "-", 
          RowBox[{"131768", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"532719336", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"367541329540", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"58954254464000", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"2565911264292864", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"22638101004288000", " ", 
           SuperscriptBox["z", "7"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "7"]}], "+", 
       RowBox[{"9", " ", 
        RowBox[{"(", 
         RowBox[{"143", "-", 
          RowBox[{"8580", " ", "z"}], "+", 
          RowBox[{"224273504", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"114210300176", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"14496709865472", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"517545887858688", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"3838911971328000", " ", 
           SuperscriptBox["z", "7"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "8"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "715"}], "+", 
          RowBox[{"57200", " ", "z"}], "-", 
          RowBox[{"1015872", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"1439914528", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"528320252432", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"51800301800448", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"1488573723082752", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"9165528052531200", " ", 
           SuperscriptBox["z", "7"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "9"]}], "+", 
       RowBox[{"22", " ", 
        RowBox[{"(", 
         RowBox[{"13", "-", 
          RowBox[{"1456", " ", "z"}], "+", 
          RowBox[{"35008688", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"8942303552", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"657862107648", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"14928471244800", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"75432591360000", " ", 
           SuperscriptBox["z", "7"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "10"]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "39"}], "+", 
          RowBox[{"6552", " ", "z"}], "-", 
          RowBox[{"328900", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"149731296", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"25419051840", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"1354605140992", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"23822900453376", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"97802256384000", " ", 
           SuperscriptBox["z", "7"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "11"]}], "+", 
       RowBox[{"13", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"280", " ", "z"}], "+", 
          RowBox[{"6131840", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"633721088", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"23487959040", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"314589708288", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"1040449536000", " ", 
           SuperscriptBox["z", "7"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "12"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"4", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"16", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"36", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"64", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"100", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"144", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"196", " ", "z"}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "13"]}]}]},
     {
      RowBox[{"1", "-", 
       RowBox[{"15", " ", "z"}], "+", 
       RowBox[{"14", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"17", " ", "z"}]}], ")"}], " ", "\[Theta]"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"91", "-", 
          RowBox[{"1768", " ", "z"}], "+", 
          RowBox[{"231", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"25502982", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"111014891100", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"73714259728440", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"12004386686674560", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"469811674173600000", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"2130017653764000000", " ", 
           SuperscriptBox["z", "8"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "2"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "91"}], "+", 
          RowBox[{"2040", " ", "z"}], "-", 
          RowBox[{"60651728", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"209273782293", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"120028142791458", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"17514091434663792", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"625303296832860000", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"2609271625860900000", " ", 
           SuperscriptBox["z", "8"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "3"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1001", "-", 
          RowBox[{"26180", " ", "z"}], "+", 
          RowBox[{"26724", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"1076498606", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"2912890763147", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"1424569091971374", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"183783626269853256", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"5906902548215394000", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"22394177271476010000", " ", 
           SuperscriptBox["z", "8"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "4"]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1001"}], "+", 
          RowBox[{"30940", " ", "z"}], "-", 
          RowBox[{"1477578562", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"3102896775101", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"1277020290116610", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"143673747885667836", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"4100975991629595000", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"13945107244878810000", " ", 
           SuperscriptBox["z", "8"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "5"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3003", "-", 
          RowBox[{"111384", " ", "z"}], "+", 
          RowBox[{"385900", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"5614667520", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"9047017307967", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"3090615889052860", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"298974506397664554", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"7476575133317908500", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"22526481608766135000", " ", 
           SuperscriptBox["z", "8"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "6"]}], "+", 
       RowBox[{"8", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "429"}], "+", 
          RowBox[{"19448", " ", "z"}], "-", 
          RowBox[{"976500264", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"1192961963584", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"333330841450092", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"27319037472603288", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"590531470857292500", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"1558746425964853125", " ", 
           SuperscriptBox["z", "8"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "7"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"3003", "-", 
          RowBox[{"170170", " ", "z"}], "+", 
          RowBox[{"1584128", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"8215979640", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"7500839165488", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"1686410285287082", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"115289888566221468", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"2125816398842854500", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"4865483786183645625", " ", 
           SuperscriptBox["z", "8"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "8"]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1001"}], "+", 
          RowBox[{"72930", " ", "z"}], "-", 
          RowBox[{"3314964640", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"2222953212288", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"394665208145550", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"22136204563657308", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"343721081454412500", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"675873830865358125", " ", 
           SuperscriptBox["z", "8"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "9"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1001", "-", 
          RowBox[{"97240", " ", "z"}], "+", 
          RowBox[{"2290002", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"4115713940", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"1982651743720", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"271840557689520", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"12291199831348182", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"158755366585390500", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"266018003390514375", " ", 
           SuperscriptBox["z", "8"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "10"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "91"}], "+", 
          RowBox[{"12376", " ", "z"}], "-", 
          RowBox[{"487045988", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"163162013534", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"16812482041008", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"601605329288832", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"6389852884042500", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"9059970923128125", " ", 
           SuperscriptBox["z", "8"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "11"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"91", "-", 
          RowBox[{"18564", " ", "z"}], "+", 
          RowBox[{"1186328", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"680125732", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"151544356470", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"11344999795244", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"315310460681376", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"2725379033251500", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"3250084807344375", " ", 
           SuperscriptBox["z", "8"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "12"]}], "+", 
       RowBox[{"14", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"340", " ", "z"}], "-", 
          RowBox[{"11717420", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"1601489318", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"83614205220", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"1772331641208", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"12352079002500", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"12326491051875", " ", 
           SuperscriptBox["z", "8"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "13"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "z"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"9", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"25", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"49", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"81", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"121", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"169", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"225", " ", "z"}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "14"]}]}]},
     {
      RowBox[{"1", "-", 
       RowBox[{"16", " ", "z"}], "+", 
       RowBox[{"15", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"18", " ", "z"}]}], ")"}], " ", "\[Theta]"}], "-", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "35"}], "+", 
          RowBox[{"714", " ", "z"}], "-", 
          RowBox[{"21218112", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"158709243392", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"171644567519232", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"47021915916730368", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"3568475893137408000", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"55231389640949760000", " ", 
           SuperscriptBox["z", "8"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "455"}], "+", 
          RowBox[{"10608", " ", "z"}], "-", 
          RowBox[{"4396", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"639791104", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"3781481408128", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"3534329347743744", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"869901443102932992", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"60493350053294899200", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"867132817362911232000", " ", 
           SuperscriptBox["z", "8"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "3"]}], "-", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "455"}], "+", 
          RowBox[{"12240", " ", "z"}], "-", 
          RowBox[{"1004595504", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"4649668363328", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"3713330830479360", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"811573158134808576", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"51116781497588121600", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"670892621558081126400", " ", 
           SuperscriptBox["z", "8"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "4"]}], "-", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"1001", "-", 
          RowBox[{"31416", " ", "z"}], "+", 
          RowBox[{"56508", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"2945399744", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"10579040846176", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"7137625676883968", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"1368839603281002496", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"77169015180836732928", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"916754129741257113600", " ", 
           SuperscriptBox["z", "8"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "5"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"5005", "-", 
          RowBox[{"185640", " ", "z"}], "+", 
          RowBox[{"18046392160", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"49847380632624", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"28084884865698816", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"4669115761662328832", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"232812229236589854720", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"2475529694909300736000", " ", 
           SuperscriptBox["z", "8"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "6"]}], "-", 
       RowBox[{"9", " ", 
        RowBox[{"(", 
         RowBox[{"715", "-", 
          RowBox[{"31824", " ", "z"}], "+", 
          RowBox[{"163200", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"3025214464", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"6362730653136", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"2957261222735872", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"420879983460761600", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"18340497166723710976", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"172683515662014873600", " ", 
           SuperscriptBox["z", "8"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "7"]}], "-", 
       RowBox[{"9", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "715"}], "+", 
          RowBox[{"38896", " ", "z"}], "-", 
          RowBox[{"3484494896", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"5520446251616", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"2088670574103552", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"251132496665542656", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"9449550275810426880", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"77981416379803238400", " ", 
           SuperscriptBox["z", "8"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "8"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "5005"}], "+", 
          RowBox[{"340340", " ", "z"}], "-", 
          RowBox[{"4306848", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"28098930624", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"33097350535424", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"10042907421941760", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"1005824949955149824", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"32288276411949514752", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"231314578693580390400", " ", 
           SuperscriptBox["z", "8"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "9"]}], "-", 
       RowBox[{"33", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "91"}], "+", 
          RowBox[{"7956", " ", "z"}], "-", 
          RowBox[{"598079040", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"515357425968", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"123258466415616", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"10127109983469568", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"274033704393768960", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"1689223925071872000", " ", 
           SuperscriptBox["z", "8"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "10"]}], "-", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"455", "-", 
          RowBox[{"53040", " ", "z"}], "+", 
          RowBox[{"1614184", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"3613523264", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"2231064116016", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"411936827207680", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"27310458625671168", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"615624041702621184", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"3238984329619046400", " ", 
           SuperscriptBox["z", "8"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "11"]}], "-", 
       RowBox[{"13", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "35"}], "+", 
          RowBox[{"5712", " ", "z"}], "-", 
          RowBox[{"353875808", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"151808202624", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"21088611615744", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"1108319136219136", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"20576717934428160", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"91732689970790400", " ", 
           SuperscriptBox["z", "8"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "12"]}], "-", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"35", "-", 
          RowBox[{"8568", " ", "z"}], "+", 
          RowBox[{"684216", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"485747392", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"138644608128", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"14025648125952", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"573537798864896", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"8676596502233088", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"32566347930009600", " ", 
           SuperscriptBox["z", "8"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "13"]}], "-", 
       RowBox[{"15", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"408", " ", "z"}], "-", 
          RowBox[{"21414016", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"3773223168", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"266836856832", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"8331813060608", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"101709156188160", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"319626097459200", " ", 
           SuperscriptBox["z", "8"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "14"]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"4", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"16", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"36", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"64", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"100", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"144", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"196", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"256", " ", "z"}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "15"]}]}]},
     {
      RowBox[{"1", "-", 
       RowBox[{"17", " ", "z"}], "+", 
       RowBox[{"16", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"19", " ", "z"}]}], ")"}], " ", "\[Theta]"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"120", "-", 
          RowBox[{"2565", " ", "z"}], "+", 
          RowBox[{"296", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"156414147", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"1980300002628", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"3397619033157276", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"1492971948703943424", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"197939679661279209600", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"6981045849035200800000", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"30163179994952004000000", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "2"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"280", "-", 
          RowBox[{"6783", " ", "z"}], "+", 
          RowBox[{"827629579", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"8251810917890", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"12231422522541054", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"4836577524365185344", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"589334210725134301920", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"19330622980495466760000", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"78208816701196981800000", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "3"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1820", "-", 
          RowBox[{"50388", " ", "z"}], "+", 
          RowBox[{"44023", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"8245375537", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"64226754321121", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"81424042817488695", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"28672176780304701552", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"3177842218601984625384", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"95963549129232732162000", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"359967971436242379210000", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "4"]}], "-", 
       RowBox[{"24", " ", 
        RowBox[{"(", 
         RowBox[{"182", "-", 
          RowBox[{"5814", " ", "z"}], "+", 
          RowBox[{"1070201904", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"6463199176010", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"6938695234143693", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"2153220684710426874", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"214818649124331099975", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"5911477927856783982000", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"20357353609556033070000", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "5"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "4004"}], "+", 
          RowBox[{"149226", " ", "z"}], "-", 
          RowBox[{"424422", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"28029815113", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"130231864846080", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"117219589457964132", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"31719672411894032282", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"2818840279270727997405", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"69978104604291953254500", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"219156615559376567572500", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "6"]}], "-", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"2860", "-", 
          RowBox[{"125970", " ", "z"}], "+", 
          RowBox[{"22743199063", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"80656017990702", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"60240321073507734", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"14061600730698492488", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"1101404558765946793815", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"24423920040009630876750", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"68947420420328503803750", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "7"]}], "-", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "4290"}], "+", 
          RowBox[{"226746", " ", "z"}], "-", 
          RowBox[{"1634380", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"37887206196", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"101659771096541", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"62314440365136425", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"12406530691156090310", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"847388189386530326046", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"16624517025607185729375", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"41954591132236794886875", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "8"]}], "-", 
       RowBox[{"16", " ", 
        RowBox[{"(", 
         RowBox[{"715", "-", 
          RowBox[{"46189", " ", "z"}], "+", 
          RowBox[{"6974028660", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"14019573997103", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"6967963051431003", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"1169141556898265338", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"68878553160451605750", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"1184414916887267915250", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"2651979235843652715000", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "9"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "4004"}], "+", 
          RowBox[{"323323", " ", "z"}], "-", 
          RowBox[{"5391516", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"43515364593", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"64756634408104", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"25740090283693875", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"3592825173300966580", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"180555809254133618115", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"2697123442396979398500", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"5321188399791312798750", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "10"]}], "-", 
       RowBox[{"12", " ", 
        RowBox[{"(", 
         RowBox[{"364", "-", 
          RowBox[{"37791", " ", "z"}], "+", 
          RowBox[{"4507748271", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"4890732918186", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"1529803268447427", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"175130384148413116", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"7423263854159317305", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"95513426697627051750", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"165013075743988972500", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "11"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "910"}], "+", 
          RowBox[{"125970", " ", "z"}], "-", 
          RowBox[{"4849845", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"13317653375", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"10329821906325", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"2493348814405167", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"230474521059656047", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"8146804049386180461", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"89573257170453317625", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"134765111678283961875", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "12"]}], "-", 
       RowBox[{"112", " ", 
        RowBox[{"(", 
         RowBox[{"5", "-", 
          RowBox[{"969", " ", "z"}], "+", 
          RowBox[{"91433225", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"49239203988", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"8949309846813", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"656600804352268", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"19139154096434175", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"178502056233877125", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"232740586380802500", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "13"]}], "-", 
       RowBox[{"12", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "10"}], "+", 
          RowBox[{"2907", " ", "z"}], "-", 
          RowBox[{"285532", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"247405080", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"88653856512", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"11756069288758", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"672089228819396", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"15980555832197280", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"125587673389905750", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"141306784588344375", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "14"]}], "-", 
       RowBox[{"8", " ", 
        RowBox[{"(", 
         RowBox[{"2", "-", 
          RowBox[{"969", " ", "z"}], "+", 
          RowBox[{"75296468", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"16748316156", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"1555719649146", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"67983344105296", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"1305213768777780", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"8592054978237750", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"8312163799314375", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "15"]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "z"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"9", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"25", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"49", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"81", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"121", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"169", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"225", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"289", " ", "z"}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "16"]}]}]},
     {
      RowBox[{"1", "-", 
       RowBox[{"18", " ", "z"}], "+", 
       RowBox[{"17", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"20", " ", "z"}]}], ")"}], " ", "\[Theta]"}], "+", 
       RowBox[{"8", " ", 
        RowBox[{"(", 
         RowBox[{"17", "-", 
          RowBox[{"380", " ", "z"}], "+", 
          RowBox[{"47394990", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"1003318413120", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"2674492601572224", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"1819414900448133120", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"393590410102112256000", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"26377691081050423296000", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"383623424598626795520000", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "2"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "170"}], "+", 
          RowBox[{"4275", " ", "z"}], "-", 
          RowBox[{"1556", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"1053157750", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"17492915505888", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"40250295922375872", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"24660309871654207488", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"4912554758284482969600", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"307084859929469229465600", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"4197936332036401790976000", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "3"]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"1190", "-", 
          RowBox[{"33915", " ", "z"}], "+", 
          RowBox[{"11055729332", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"143079644911648", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"281616389892495936", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"153934170184079106048", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"27976693094931205324800", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"1616415679973276673638400", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"20586233342507185550131200", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "4"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1547"}], "+", 
          RowBox[{"50388", " ", "z"}], "-", 
          RowBox[{"77140", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"18221348662", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"182508452474392", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"304587254437287312", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"147159441252294813696", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"24174420793068402081792", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"1279229117565383529725952", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"15043790731575749404262400", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "5"]}], "+", 
       RowBox[{"8", " ", 
        RowBox[{"(", 
         RowBox[{"1547", "-", 
          RowBox[{"58140", " ", "z"}], "+", 
          RowBox[{"21139968233", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"162816201895650", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"228394002622361220", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"96631920936355002880", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"14215284328045380526080", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"682732004258658826321920", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"7349970250382872412160000", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "6"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "4862"}], "+", 
          RowBox[{"213180", " ", "z"}], "-", 
          RowBox[{"892449", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"73357960624", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"431550836943804", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"504341625970504896", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"185107597650364069376", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"24158285104833648893952", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"1043706985428623837626368", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"10200611860519170185625600", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "7"]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"12155", "-", 
          RowBox[{"629850", " ", "z"}], "+", 
          RowBox[{"197259466952", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"880210800355560", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"849091250905794000", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"267722378039560062976", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"30705427070019845406720", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"1182795598801837152534528", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"10411725381485257241395200", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "8"]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "12155"}], "+", 
          RowBox[{"755820", " ", "z"}], "-", 
          RowBox[{"7364400", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"210118246824", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"705600556078488", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"556226190211191744", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"149125540052203316224", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"14885273081388256837632", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"506814597792409520701440", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"3988079989687302959923200", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "9"]}], "+", 
       RowBox[{"88", " ", 
        RowBox[{"(", 
         RowBox[{"221", "-", 
          RowBox[{"16796", " ", "z"}], "+", 
          RowBox[{"4082274906", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"10223678680894", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"6512989261649796", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"1468457482960263680", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"126298802492375224320", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"3768479892531448381440", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"26321856368612474880000", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "10"]}], "+", 
       RowBox[{"8", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1547"}], "+", 
          RowBox[{"146965", " ", "z"}], "-", 
          RowBox[{"3149250", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"30994118106", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"57249437093254", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"29097696131072064", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"5451174178566184192", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"399829559425806716928", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"10367499163086245855232", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"63856340707089737318400", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "11"]}], "+", 
       RowBox[{"52", " ", 
        RowBox[{"(", 
         RowBox[{"119", "-", 
          RowBox[{"14535", " ", "z"}], "+", 
          RowBox[{"2656859756", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"3567624901236", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"1424887595963064", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"218864543414447104", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"13544977435035770880", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"302744583838293295104", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"1634374488617385984000", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "12"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "595"}], "+", 
          RowBox[{"96900", " ", "z"}], "-", 
          RowBox[{"4635696", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"15408767972", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"14762667081012", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"4547864410050576", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"564300012017202688", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"29146643233845092352", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"557183576855144300544", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"2621885845683673497600", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "13"]}], "+", 
       RowBox[{"40", " ", 
        RowBox[{"(", 
         RowBox[{"17", "-", 
          RowBox[{"3876", " ", "z"}], "+", 
          RowBox[{"541410662", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"359910398640", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"83538670257504", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"8235648049659904", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"351122419385118720", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"5698747990745284608", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"23257592981618688000", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "14"]}], "+", 
       RowBox[{"8", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "17"}], "+", 
          RowBox[{"5814", " ", "z"}], "-", 
          RowBox[{"692835", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"723492868", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"319997862288", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"54274745326272", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"4174328939749376", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"145305636880490496", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"1988575185990057984", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"7007482560695500800", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "15"]}], "+", 
       RowBox[{"17", " ", 
        RowBox[{"(", 
         RowBox[{"1", "-", 
          RowBox[{"570", " ", "z"}], "+", 
          RowBox[{"63979840", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"17649505536", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"2100623316480", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"123605335212032", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"3476093445734400", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"39864146023415808", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"120818664839577600", " ", 
           SuperscriptBox["z", "9"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "16"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"4", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"16", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"36", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"64", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"100", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"144", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"196", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"256", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"324", " ", "z"}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "17"]}]}]},
     {
      RowBox[{"1", "-", 
       RowBox[{"19", " ", "z"}], "+", 
       RowBox[{"18", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"21", " ", "z"}]}], ")"}], " ", "\[Theta]"}], "+", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"51", "-", 
          RowBox[{"1190", " ", "z"}], "+", 
          RowBox[{"123", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"302765196", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"10608514406048", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"43200736590784644", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"44268548809274187840", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"14888578027702480416000", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"1707116156566826605344000", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"55737746453209867956000000", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"232296703534457033472000000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "2"]}], "+", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "204"}], "+", 
          RowBox[{"5320", " ", "z"}], "-", 
          RowBox[{"2641892907", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"72359480550788", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"254028011801126697", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"234497617910227861704", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"72718186218612670720800", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"7792844721848172926172000", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"239812917501058736341500000", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"947023882444938227529600000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "3"]}], "+", 
       RowBox[{"9", " ", 
        RowBox[{"(", 
         RowBox[{"340", "-", 
          RowBox[{"9975", " ", "z"}], "+", 
          RowBox[{"7616", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"6474835446", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"137758555769936", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"413514852771549987", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"340937896926120397884", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"96660622295135794034480", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"9602027105807423192333040", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"276272861969498804060310000", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"1025673018952594348496160000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "4"]}], "+", 
       RowBox[{"6", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1428"}], "+", 
          RowBox[{"47481", " ", "z"}], "-", 
          RowBox[{"33754082640", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"554603954348678", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"1412267324350535529", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"1031294094690611587734", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"265082085665953743696680", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"24208913895334485056934768", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"646039266256314106921962000", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"2237285485959730386059880000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "5"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"18564", "-", 
          RowBox[{"705432", " ", "z"}], "+", 
          RowBox[{"1699075", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"497520944920", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"6277381930127374", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"13456252877834676628", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"8631195354046000955659", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"1994692284114947956347772", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"166115461753643399975202120", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"4079240852330889328726467000", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"13078755116227251461580570000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "6"]}], "+", 
       RowBox[{"24", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1326"}], "+", 
          RowBox[{"58140", " ", "z"}], "-", 
          RowBox[{"38256105503", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"368602033413389", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"660024974313072189", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"368787627796493943092", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"75992706168320808105815", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"5724499779147049517298717", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"128369331961608688709873625", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"378329922507507941110140000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "7"]}], "+", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"14586", "-", 
          RowBox[{"746130", " ", "z"}], "+", 
          RowBox[{"4368252", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"440111371714", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"3219452501067851", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"4777370532661551087", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"2305583813337709738402", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"420059134513589617454576", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"28393756732288997484326373", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"577127009482605027982738125", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"1553049632794245453622755000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "8"]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "24310"}], "+", 
          RowBox[{"1469650", " ", "z"}], "-", 
          RowBox[{"756999636698", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"4178072578462895", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"5094799711590156453", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"2104954729253004002754", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"336176298206249709122700", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"20228033042613490265487009", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"370004328981407893648908375", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"903445241232630789265072500", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "9"]}], "+", 
       RowBox[{"9", " ", 
        RowBox[{"(", 
         RowBox[{"4862", "-", 
          RowBox[{"352716", " ", "z"}], "+", 
          RowBox[{"4505850", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"156064545664", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"645285109896539", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"640690184385374050", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"224485755248959904197", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"31149127676543812345324", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"1655161895254407820773079", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"27058076631990827399463750", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"59600400981499604441840625", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "10"]}], "+", 
       RowBox[{"24", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1326"}], "+", 
          RowBox[{"117572", " ", "z"}], "-", 
          RowBox[{"44283568413", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"136020732416198", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"108828641885519571", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"32008588105480769844", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"3823282586728093243555", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"177984509997736760823036", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"2583279903803695304504625", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"5105739403520484924195000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "11"]}], "+", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"9282", "-", 
          RowBox[{"1028755", " ", "z"}], "+", 
          RowBox[{"27746992", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"328830641606", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"742571432607270", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"473033146122067996", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"115478508471880789610", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"11759274322186907281322", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"475820004164032590669936", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"6093112717833763529750625", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"10753255305523418406468750", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "12"]}], "+", 
       RowBox[{"84", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "102"}], "+", 
          RowBox[{"14535", " ", "z"}], "-", 
          RowBox[{"3952149188", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"6472006214912", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"3235614131045118", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"647412130741936028", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"55638237335443126580", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"1941610840051786332390", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"21807227543860435532625", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"34213022941638183142500", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "13"]}], "+", 
       RowBox[{"6", " ", 
        RowBox[{"(", 
         RowBox[{"510", "-", 
          RowBox[{"96900", " ", "z"}], "+", 
          RowBox[{"5672849", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"22560655936", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"26313391564880", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"10142658140985512", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"1639897972371011662", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"117692006581651209632", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"3515207860157864756538", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"34438197355561874416500", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"47840018710341338105625", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "14"]}], "+", 
       RowBox[{"48", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "17"}], "+", 
          RowBox[{"4522", " ", "z"}], "-", 
          RowBox[{"912186884", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"737816678326", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"214373770511328", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"27560920569928840", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"1633999444645957340", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"41464761574211402211", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"352547099588459270250", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"432099522943558470000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "15"]}], "+", 
       RowBox[{"9", " ", 
        RowBox[{"(", 
         RowBox[{"17", "-", 
          RowBox[{"6783", " ", "z"}], "+", 
          RowBox[{"969000", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"1206021276", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"648908967070", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"137950544873954", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"13850588205345052", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"670954811400272812", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"14365376943885058361", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"105511400736062124375", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"113740482891227692500", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "16"]}], "+", 
       RowBox[{"18", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"665", " ", "z"}], "-", 
          RowBox[{"105511180", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"35556183026", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"5312466423810", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"408401534280452", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"15991348898146300", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"287005329806386023", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"1813499659400223375", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"1714680646601422500", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "17"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "z"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"9", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"25", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"49", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"81", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"121", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"169", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"225", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"289", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"361", " ", "z"}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "18"]}]}]},
     {
      RowBox[{"1", "-", 
       RowBox[{"20", " ", "z"}], "+", 
       RowBox[{"19", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"22", " ", "z"}]}], ")"}], " ", "\[Theta]"}], "-", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "57"}], "+", 
          RowBox[{"1386", " ", "z"}], "-", 
          RowBox[{"717744960", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"41273339752960", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"253228576580204544", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"382443453848184422400", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"192896928532638203904000", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"35325104520763401043968000", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"2158236003692585366323200000", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"29929934231542387703808000000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "2"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "969"}], "+", 
          RowBox[{"26180", " ", "z"}], "-", 
          RowBox[{"8496", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"26174498640", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"1172081808635264", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"6189720190845525504", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"8420045660756815380480", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"3918770918787264911769600", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"671689551690275709203251200", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"38755254747898587213987840000", " ", 
           SuperscriptBox["z", "9"]}], "-", 
          RowBox[{"510519163892308727404953600000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "3"]}], "-", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "969"}], "+", 
          RowBox[{"29260", " ", "z"}], "-", 
          RowBox[{"37808641938", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"1311014738915024", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"5914757366832348672", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"7190345571632137101312", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"3064001901102261426585600", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"487855025763509353630924800", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"26388591078392471010410496000", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"327845048902037862497648640000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "4"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"5814", "-", 
          RowBox[{"197505", " ", "z"}], "+", 
          RowBox[{"263032", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"276241131504", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"7378624689360240", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"28237529480442678016", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"30443555858434695979008", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"11787508718085457833885696", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"1730428945762725467397292032", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"87110292149625968174039040000", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"1013449762843127395626516480000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "5"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "13566"}], "+", 
          RowBox[{"522291", " ", "z"}], "-", 
          RowBox[{"715834619632", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"14656628759566376", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"47251586472164917248", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"44843596906698631561216", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"15658431855961547207475200", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"2103780205089222041234571264", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"97856076518308532006682624000", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"1058751553837925854064148480000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "6"]}], "-", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"12597", "-", 
          RowBox[{"554268", " ", "z"}], "+", 
          RowBox[{"1956031", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"699584138440", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"10927142817944140", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"29475734410084598728", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"24442493441220626108416", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"7639558961851075996549120", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"932535521681786969769639936", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"39798931434364799809486848000", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"397791829645289619235799040000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "7"]}], "-", 
       RowBox[{"6", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "12597"}], "+", 
          RowBox[{"639540", " ", "z"}], "-", 
          RowBox[{"713627061532", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"8462282857580992", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"18968140778987484432", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"13640986366376478063616", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"3787722959729287747747840", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"417024273907950957090570240", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"16218049332938899684589568000", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"148795595703636823501701120000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "8"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"46189", "-", 
          RowBox[{"2735810", " ", "z"}], "+", 
          RowBox[{"21552498", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"2626471601512", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"23524133019098624", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"43501616532481060656", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"26921869660100406974976", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"6590540639372825513459712", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"649724326791137016570445824", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"22870482245528777423585280000", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"191440767295438240622837760000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "9"]}], "-", 
       RowBox[{"22", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "4199"}], "+", 
          RowBox[{"293930", " ", "z"}], "-", 
          RowBox[{"238528166608", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"1604618949705568", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"2429202936930929616", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"1283225796504171697152", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"274772331041679507456000", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"24078402590230627043770368", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"762126574159662371831808000", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"5786986409643361865564160000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "10"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"37791", "-", 
          RowBox[{"3174444", " ", "z"}], "+", 
          RowBox[{"51873800", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"2154990573120", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"10817865492442272", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"13293078057466660112", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"5941616283298341210624", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"1103711643337332965376000", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"85339815740879356728705024", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"2413353210113266896863232000", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"16533118498528481677148160000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "11"]}], "-", 
       RowBox[{"52", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "969"}], "+", 
          RowBox[{"99484", " ", "z"}], "-", 
          RowBox[{"56236144976", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"209008700118240", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"206452913904480936", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"77336708854196076032", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"12355602528629975695360", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"836695421534715252572160", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"21008964998134147055616000", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"129192792905548761661440000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "12"]}], "-", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"6783", "-", 
          RowBox[{"870485", " ", "z"}], "+", 
          RowBox[{"29040284", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"409867475296", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"1116839208898008", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"876756786452752520", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"272340466235998496512", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"37081068571807666438144", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"2182766790552624663625728", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"48373345279416635228160000", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"265756642801951986155520000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "13"]}], "-", 
       RowBox[{"12", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "969"}], "+", 
          RowBox[{"159885", " ", "z"}], "-", 
          RowBox[{"63025646320", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"124270078476964", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"76477121652195000", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"19463808479054714368", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"2236834938914295808000", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"113600599517495239114752", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"2209253779561871572992000", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"10796162580200911011840000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "14"]}], "-", 
       RowBox[{"12", " ", 
        RowBox[{"(", 
         RowBox[{"323", "-", 
          RowBox[{"71060", " ", "z"}], "+", 
          RowBox[{"5023942", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"23660551040", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"33174889207068", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"15734574279023920", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"3236561456812713216", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"310763675066773012480", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"13515511755231487328256", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"229402049238509027328000", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"993177752447263703040000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "15"]}], "-", 
       RowBox[{"51", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "19"}], "+", 
          RowBox[{"5852", " ", "z"}], "-", 
          RowBox[{"1668090864", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"1621231491712", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"579816088290048", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"94898822364577792", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"7532177797529763840", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"278486954483295191040", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"4104401870993227776000", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"15685714658029731840000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "16"]}], "-", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{"57", "-", 
          RowBox[{"26334", " ", "z"}], "+", 
          RowBox[{"4462568", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"6554915488", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"4236899838080", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"1109892677230592", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"141988681753059328", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"9214353418928193536", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"287585330825020833792", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"3662989794465546240000", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"12316599889931796480000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "17"]}], "-", 
       RowBox[{"19", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"770", " ", "z"}], "-", 
          RowBox[{"169407040", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"68833377536", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"12690326638080", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"1243937770668032", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"65278761051750400", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"1708388999975927808", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"18724086809100288000", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"55231389640949760000", " ", 
           SuperscriptBox["z", "10"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "18"]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"4", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"16", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"36", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"64", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"100", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"144", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"196", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"256", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"324", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"400", " ", "z"}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "19"]}]}]},
     {
      RowBox[{"1", "-", 
       RowBox[{"21", " ", "z"}], "+", 
       RowBox[{"20", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"23", " ", "z"}]}], ")"}], " ", "\[Theta]"}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"190", "-", 
          RowBox[{"4807", " ", "z"}], "+", 
          RowBox[{"450", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"5057366985", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"473847430980240", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"4329693759783742848", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"9468205479042801972480", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"6964830504259491904286400", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"1940336711675249852878099200", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"199661397086795971762731744000", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"6142770766251626976290304000000", " ", 
           SuperscriptBox["z", "10"]}], "-", 
          RowBox[{"24893611640863019077959936000000", " ", 
           SuperscriptBox["z", "11"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "2"]}], "-", 
       RowBox[{"6", " ", 
        RowBox[{"(", 
         RowBox[{"190", "-", 
          RowBox[{"5313", " ", "z"}], "+", 
          RowBox[{"10683530675", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"776551389001400", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"6096636732973658040", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"12003092211239836132032", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"8150424618981608213963760", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"2127303415689670317160687680", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"207022310968284528912463464000", " ", 
           SuperscriptBox["z", "9"]}], "-", 
          RowBox[{"6061286393923749956610854400000", " ", 
           SuperscriptBox["z", "10"]}], "+", 
          RowBox[{"23474412352872018916240262400000", " ", 
           SuperscriptBox["z", "11"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "3"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"4845", "-", 
          RowBox[{"150535", " ", "z"}], "+", 
          RowBox[{"102051", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"387173776053", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"21721306931019700", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"145518281342209688220", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"256066384057283192671440", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"159354862032176113869189756", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"38696743864624302615672286128", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"3537586254103836370272508515120", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"97923901587734692523774105280000", " ", 
           SuperscriptBox["z", "10"]}], "-", 
          RowBox[{"360119824044218369759485297440000", " ", 
           SuperscriptBox["z", "11"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "4"]}], "-", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"3876", "-", 
          RowBox[{"134596", " ", "z"}], "+", 
          RowBox[{"370677239859", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"15976156796614844", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"90739927858526059194", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"141719831314150469012424", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"80265345111118362400739415", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"18010130107205741121511368624", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"1536350546747990716914194596944", " ", 
           SuperscriptBox["z", "9"]}], "-", 
          RowBox[{"39946362278514896287798982568000", " ", 
           SuperscriptBox["z", "10"]}], "+", 
          RowBox[{"138613782753112322800323679500000", " ", 
           SuperscriptBox["z", "11"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "5"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"38760", "-", 
          RowBox[{"1514205", " ", "z"}], "+", 
          RowBox[{"3159464", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"4040391596389", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"133199329892491392", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"637424115602155123439", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"877639437678270808571704", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"449287615546194109438482519", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"92526319309870576232393623704", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"7316903722997716855429206325032", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"177564166273077212067555858588000", " ", 
           SuperscriptBox["z", "10"]}], "-", 
          RowBox[{"577814540844266535255560764650000", " ", 
           SuperscriptBox["z", "11"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "6"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{"38760", "-", 
          RowBox[{"1716099", " ", "z"}], "+", 
          RowBox[{"4166836628735", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"104636101234773100", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"419351624966724560655", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"505623148643479518858056", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"232385926101748518587252065", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"43632957222054794561841023220", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"3178098473456539042449907577220", " ", 
           SuperscriptBox["z", "9"]}], "-", 
          RowBox[{"71540756774403517142336071872000", " ", 
           SuperscriptBox["z", "10"]}], "+", 
          RowBox[{"217041385696918978324514234850000", " ", 
           SuperscriptBox["z", "11"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "7"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"125970", "-", 
          RowBox[{"6374082", " ", "z"}], "+", 
          RowBox[{"31327219", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"13510056547735", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"257358396301621159", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"858568975394258034415", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"900502776124401332943577", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"369068405537230661820197269", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"62763382525198217063292897435", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"4184079885738584421590050371819", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"86845704808090870080844099380000", " ", 
           SuperscriptBox["z", "10"]}], "-", 
          RowBox[{"244273579002136296317907317115000", " ", 
           SuperscriptBox["z", "11"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "8"]}], "-", 
       RowBox[{"4", " ", 
        RowBox[{"(", 
         RowBox[{"41990", "-", 
          RowBox[{"2451570", " ", "z"}], "+", 
          RowBox[{"4410198657238", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"63462277428536283", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"175142315347280955945", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"158708509893672683355210", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"57608507826434216401072350", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"8814713004754755827222789973", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"534483180210264182014843255383", " ", 
           SuperscriptBox["z", "9"]}], "-", 
          RowBox[{"10170404650239275393847831379500", " ", 
           SuperscriptBox["z", "10"]}], "+", 
          RowBox[{"26383125694830808531989329718750", " ", 
           SuperscriptBox["z", "11"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "9"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"184756", "-", 
          RowBox[{"12584726", " ", "z"}], "+", 
          RowBox[{"129442896", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"18858995567368", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"204068495235498674", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"462846257677189569159", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"359798223819523426082514", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"114856792421089937005334451", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"15707400986085612463185602778", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"860973470686433987815848131439", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"14936057709504491187936834198750", " ", 
           SuperscriptBox["z", "10"]}], "-", 
          RowBox[{"35558654625137359477918096565625", " ", 
           SuperscriptBox["z", "11"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "10"]}], "-", 
       RowBox[{"10", " ", 
        RowBox[{"(", 
         RowBox[{"16796", "-", 
          RowBox[{"1352078", " ", "z"}], "+", 
          RowBox[{"1668271484308", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"13505604030994306", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"24995403133135189029", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"16543089237184341511092", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"4610549745599990267021835", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"559745172343629758724710814", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"27567495951614145529570203489", " ", 
           SuperscriptBox["z", "9"]}], "-", 
          RowBox[{"433679158883502889201642732200", " ", 
           SuperscriptBox["z", "10"]}], "+", 
          RowBox[{"943198136328320090411784215625", " ", 
           SuperscriptBox["z", "11"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "11"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"125970", "-", 
          RowBox[{"12168702", " ", "z"}], "+", 
          RowBox[{"249242950", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"12287919159802", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"73979235922162263", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"110835070729583573065", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"61946682922753475163787", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"14957541191411469530731845", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"1601031188794312332696172707", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"70425139323979463922200217933", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"999560846761220660492061115875", " ", 
           SuperscriptBox["z", "10"]}], "-", 
          RowBox[{"1977492682276270611702843718125", " ", 
           SuperscriptBox["z", "11"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "12"]}], "-", 
       RowBox[{"8", " ", 
        RowBox[{"(", 
         RowBox[{"9690", "-", 
          RowBox[{"1144066", " ", "z"}], "+", 
          RowBox[{"944321578091", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"4196912954089296", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"5043582228234769590", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"2359134487052937689744", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"489520047474242063633620", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"45873986474882577292897266", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"1791676621238029834176429876", " ", 
           SuperscriptBox["z", "9"]}], "-", 
          RowBox[{"22832077903502118927186861000", " ", 
           SuperscriptBox["z", "10"]}], "+", 
          RowBox[{"40927024005900529552696265625", " ", 
           SuperscriptBox["z", "11"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "13"]}], "-", 
       RowBox[{"2", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "19380"}], "+", 
          RowBox[{"2860165", " ", "z"}], "-", 
          RowBox[{"116278708", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"1935424245221", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"6291092072473488", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"5999000490263524450", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"2324793388402299000560", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"410974433600104384010378", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"33478552415569802507929116", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"1154318847792715436314009113", " ", 
           SuperscriptBox["z", "9"]}], "-", 
          RowBox[{"13146965700090372590326645500", " ", 
           SuperscriptBox["z", "10"]}], "+", 
          RowBox[{"21275350511442540039642740625", " ", 
           SuperscriptBox["z", "11"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "14"]}], "-", 
       RowBox[{"12", " ", 
        RowBox[{"(", 
         RowBox[{"1292", "-", 
          RowBox[{"245157", " ", "z"}], "+", 
          RowBox[{"136986042585", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"321592873484680", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"240159805893912318", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"76229069635300723328", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"11374753324029263073730", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"799661493370892360335140", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"24204937542358491050556375", " ", 
           SuperscriptBox["z", "9"]}], "-", 
          RowBox[{"245329467732789353288172000", " ", 
           SuperscriptBox["z", "10"]}], "+", 
          RowBox[{"357232744318449250729603125", " ", 
           SuperscriptBox["z", "11"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "15"]}], "-", 
       RowBox[{"3", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1615"}], "+", 
          RowBox[{"408595", " ", "z"}], "-", 
          RowBox[{"34485418", " ", 
           SuperscriptBox["z", "2"]}], "+", 
          RowBox[{"190575854698", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"317701786347834", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"182779269086172610", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"46896710997326517360", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"5848751349060735996848", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"352270357918872719809023", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"9310554963592001702852499", " ", 
           SuperscriptBox["z", "9"]}], "-", 
          RowBox[{"83642679447997561718982750", " ", 
           SuperscriptBox["z", "10"]}], "+", 
          RowBox[{"109263764080609167578298750", " ", 
           SuperscriptBox["z", "11"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "16"]}], "-", 
       RowBox[{"12", " ", 
        RowBox[{"(", 
         RowBox[{"95", "-", 
          RowBox[{"33649", " ", "z"}], "+", 
          RowBox[{"13294700672", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"15356722721662", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"6663818272881330", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"1361179854942878476", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"140406804984026998340", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"7192841610689205752457", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"165148664292069713166807", " ", 
           SuperscriptBox["z", "9"]}], "-", 
          RowBox[{"1310171423845163948743500", " ", 
           SuperscriptBox["z", "10"]}], "+", 
          RowBox[{"1531252684431235328062500", " ", 
           SuperscriptBox["z", "11"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "17"]}], "+", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{"190", "-", 
          RowBox[{"100947", " ", "z"}], "+", 
          RowBox[{"20102874", " ", 
           SuperscriptBox["z", "2"]}], "-", 
          RowBox[{"34544173961", " ", 
           SuperscriptBox["z", "3"]}], "+", 
          RowBox[{"26529307360668", " ", 
           SuperscriptBox["z", "4"]}], "-", 
          RowBox[{"8439944494316190", " ", 
           SuperscriptBox["z", "5"]}], "+", 
          RowBox[{"1348533338822744932", " ", 
           SuperscriptBox["z", "6"]}], "-", 
          RowBox[{"113797334641318263474", " ", 
           SuperscriptBox["z", "7"]}], "+", 
          RowBox[{"4923267570167878534086", " ", 
           SuperscriptBox["z", "8"]}], "-", 
          RowBox[{"97725353987773092882303", " ", 
           SuperscriptBox["z", "9"]}], "+", 
          RowBox[{"682325948526246419897250", " ", 
           SuperscriptBox["z", "10"]}], "-", 
          RowBox[{"711748932948592717303125", " ", 
           SuperscriptBox["z", "11"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "18"]}], "-", 
       RowBox[{"10", " ", 
        RowBox[{"(", 
         RowBox[{"2", "-", 
          RowBox[{"1771", " ", "z"}], "+", 
          RowBox[{"531091781", " ", 
           SuperscriptBox["z", "3"]}], "-", 
          RowBox[{"257234087572", " ", 
           SuperscriptBox["z", "4"]}], "+", 
          RowBox[{"57665762991018", " ", 
           SuperscriptBox["z", "5"]}], "-", 
          RowBox[{"7064263582961464", " ", 
           SuperscriptBox["z", "6"]}], "+", 
          RowBox[{"482245389340490930", " ", 
           SuperscriptBox["z", "7"]}], "-", 
          RowBox[{"17499254333410815966", " ", 
           SuperscriptBox["z", "8"]}], "+", 
          RowBox[{"298955483689571664417", " ", 
           SuperscriptBox["z", "9"]}], "-", 
          RowBox[{"1831437017968628007000", " ", 
           SuperscriptBox["z", "10"]}], "+", 
          RowBox[{"1701391871590261475625", " ", 
           SuperscriptBox["z", "11"]}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "19"]}], "-", 
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", "z"}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"9", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"25", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"49", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"81", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"121", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"169", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"225", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"289", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"361", " ", "z"}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"441", " ", "z"}]}], ")"}], " ", 
        SuperscriptBox["\[Theta]", "20"]}]}]}
    },
    GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Baseline}}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.5599999999999999]}, 
        Offset[0.27999999999999997`]}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}}],
   Column],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{3.805697207652443*^9, 3.805697268547428*^9},
 CellLabel->
  "Out[2665]//TableForm=",ExpressionUUID->"fa134b84-3b2e-468b-b2d7-\
0fb55f8f20bc"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Two-Loop Sunset Non-Equal Mass Differential Equations", "Chapter",
 CellChangeTimes->{{3.805696981904331*^9, 
  3.805697009704138*^9}},ExpressionUUID->"c81a392a-e878-42b7-a0a4-\
12e6f59e910c"],

Cell["Homogeneous Operators", "Text",
 CellChangeTimes->{{3.8056982758585243`*^9, 
  3.8056982812475567`*^9}},ExpressionUUID->"a225101e-4358-4ff9-a49f-\
4480ff700161"],

Cell[BoxData[{
 RowBox[{
  SubsuperscriptBox["\[Theta]", "1", "2"], "-", 
  RowBox[{
   SubscriptBox["z", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["\[Theta]", "1"]}], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"]}], ")"}]}], "-", 
  RowBox[{
   SubscriptBox["z", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["z", "2"], "+", 
     SubscriptBox["z", "3"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"]}], ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubsuperscriptBox["\[Theta]", "2", "2"], "-", 
  RowBox[{
   SubscriptBox["z", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Theta]", "1"], "-", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"]}], ")"}]}], "-", 
  RowBox[{
   SubscriptBox["z", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["z", "1"], "+", 
     SubscriptBox["z", "3"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"]}], ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubsuperscriptBox["\[Theta]", "3", "2"], "-", 
  RowBox[{
   SubscriptBox["z", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "-", 
     SubscriptBox["\[Theta]", "3"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"]}], ")"}]}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["z", "1"], "+", 
     SubscriptBox["z", "2"]}], ")"}], " ", 
   SubscriptBox["z", "3"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"]}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.805698332887928*^9, 
  3.805698345195043*^9}},ExpressionUUID->"c1aa36ff-d78e-463b-ad9b-\
2c90884f46e5"],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{
  3.805698573802699*^9},ExpressionUUID->"c39f05a7-14b0-457c-b631-\
b4f7e9333d27"],

Cell["Inhomogeneous Differential equation", "Text",
 CellChangeTimes->{{3.805698375392599*^9, 
  3.8056983922982073`*^9}},ExpressionUUID->"b0da2851-75ac-4964-b555-\
319b9554275c"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Theta]", "2"], "-", 
  SubscriptBox["\[Theta]", "3"], "-", 
  RowBox[{
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "+", 
  RowBox[{
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "+", 
  RowBox[{
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "-", 
  RowBox[{
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"2", "  ", 
   SubscriptBox["z", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["z", "2"], "-", 
     SubscriptBox["z", "3"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.805698945437544*^9, 
  3.8056989651381073`*^9}},ExpressionUUID->"42cf56c7-b4a1-49ed-a249-\
3874a248747e"],

Cell["Corresponding Inhomogeneity", "Text",
 CellChangeTimes->{{3.805698576477152*^9, 
  3.805698588439147*^9}},ExpressionUUID->"ddcec24a-9d3e-4537-a18f-\
aad64c381781"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Log", "[", 
    SubscriptBox["z", "2"], "]"}]}], "+", 
  RowBox[{"Log", "[", 
   SubscriptBox["z", "3"], "]"}]}]], "Input",
 CellChangeTimes->{{3.805699014334144*^9, 
  3.8056990170000877`*^9}},ExpressionUUID->"a31f1ea7-96ec-43a7-b9c0-\
706e51774a5c"],

Cell["Inhomogeneous Differential equation", "Text",
 CellChangeTimes->{{3.805698375392599*^9, 
  3.8056983922982073`*^9}},ExpressionUUID->"e40ca34d-aa34-49db-a4ff-\
97aaec15ebb8"],

Cell[BoxData[
 RowBox[{
  SubscriptBox["\[Theta]", "1"], "-", 
  SubscriptBox["\[Theta]", "2"], "+", 
  RowBox[{
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "+", 
  RowBox[{
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "-", 
  RowBox[{
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "-", 
  RowBox[{
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "-", 
  RowBox[{
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["z", "1"], "-", 
     SubscriptBox["z", "2"]}], ")"}], " ", 
   SubscriptBox["z", "3"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.8056989868853207`*^9, 
  3.805698994915913*^9}},ExpressionUUID->"f7f451d8-5183-444e-9971-\
eac1985b2a73"],

Cell["Corresponding Inhomogeneity", "Text",
 CellChangeTimes->{{3.805698576477152*^9, 
  3.805698588439147*^9}},ExpressionUUID->"728c1050-58a4-4aca-8ba4-\
767ded27c619"],

Cell[BoxData[
 RowBox[{
  RowBox[{"-", 
   RowBox[{"Log", "[", 
    SubscriptBox["z", "1"], "]"}]}], "+", 
  RowBox[{"Log", "[", 
   SubscriptBox["z", "2"], "]"}]}]], "Input",ExpressionUUID->"a9cbfb73-c96d-\
46b0-8cf2-a77cd77eb061"]
}, Closed]],

Cell[CellGroupData[{

Cell["Three - Loop Banana Non - Equal Mass Differential Equations", "Chapter",
 CellChangeTimes->{{3.805697015140987*^9, 
  3.8056970219891787`*^9}},ExpressionUUID->"885149db-9093-45d2-97b9-\
e272eb3da75c"],

Cell["Homogeneous Operators", "Text",
 CellChangeTimes->{{3.805703049496501*^9, 
  3.805703051195733*^9}},ExpressionUUID->"8cb0f846-9ea4-4392-bd4e-\
af710ae8c2fe"],

Cell[BoxData[{
 RowBox[{
  SubsuperscriptBox["\[Theta]", "1", "2"], "-", 
  RowBox[{
   SubscriptBox["z", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["\[Theta]", "1"]}], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"]}], ")"}]}], "-", 
  RowBox[{
   SubscriptBox["z", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["z", "2"], "+", 
     SubscriptBox["z", "3"], "+", 
     SubscriptBox["z", "4"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"]}], ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubsuperscriptBox["\[Theta]", "2", "2"], "-", 
  RowBox[{
   SubscriptBox["z", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Theta]", "1"], "-", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"]}], ")"}]}], "-", 
  RowBox[{
   SubscriptBox["z", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["z", "1"], "+", 
     SubscriptBox["z", "3"], "+", 
     SubscriptBox["z", "4"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"]}], ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubsuperscriptBox["\[Theta]", "3", "2"], "-", 
  RowBox[{
   SubscriptBox["z", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "-", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"]}], ")"}]}], "-", 
  RowBox[{
   SubscriptBox["z", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["z", "1"], "+", 
     SubscriptBox["z", "2"], "+", 
     SubscriptBox["z", "4"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"]}], ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubsuperscriptBox["\[Theta]", "4", "2"], "-", 
  RowBox[{
   SubscriptBox["z", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "-", 
     SubscriptBox["\[Theta]", "4"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"]}], ")"}]}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["z", "1"], "+", 
     SubscriptBox["z", "2"], "+", 
     SubscriptBox["z", "3"]}], ")"}], " ", 
   SubscriptBox["z", "4"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"]}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.80570303553242*^9, 
  3.805703044340579*^9}},ExpressionUUID->"21bf6cfa-cbc6-4d11-92cd-\
ba9aa7a0e8c6"],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{
  3.805698573802699*^9},ExpressionUUID->"ea286b26-4dbf-4e51-b1c6-\
fef3533513ba"],

Cell["Inhomogeneous Differential equation", "Text",
 CellChangeTimes->{{3.805698375392599*^9, 
  3.8056983922982073`*^9}},ExpressionUUID->"3694dcc2-822a-4889-b637-\
290956c1bf4c"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "6"}], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "+", 
  RowBox[{"5", " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"5", " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"6", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["z", "1"], " ", 
   SubsuperscriptBox["\[Theta]", "1", "2"]}], "-", 
  RowBox[{"6", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "-", 
  RowBox[{"8", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{"8", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{"6", " ", 
   SubscriptBox["z", "1"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "-", 
  RowBox[{"8", " ", 
   SubscriptBox["z", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "+", 
  RowBox[{"6", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"4", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"8", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"4", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"4", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"6", " ", 
   SubscriptBox["z", "1"], " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "+", 
  RowBox[{"12", " ", 
   SubscriptBox["z", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "+", 
  RowBox[{"6", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"9", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"13", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"9", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"13", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"25", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"11", " ", 
   SubscriptBox["z", "1"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "+", 
  RowBox[{"17", " ", 
   SubscriptBox["z", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "+", 
  RowBox[{"2", " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"6", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"]}], "+", 
     RowBox[{"6", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "3"]}], "-", 
     RowBox[{"5", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "4"]}], "+", 
     RowBox[{"11", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "4"]}], "+", 
     RowBox[{
      SubsuperscriptBox["z", "1", "2"], " ", 
      SubscriptBox["\[Theta]", "1"]}], "-", 
     RowBox[{"3", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["\[Theta]", "1"]}], "+", 
     RowBox[{
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["\[Theta]", "1"]}], "+", 
     RowBox[{"3", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "1"]}], "+", 
     RowBox[{"3", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "1"]}], "-", 
     RowBox[{"5", " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "1"]}], "-", 
     RowBox[{
      SubsuperscriptBox["z", "1", "2"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "+", 
     RowBox[{"9", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "-", 
     RowBox[{
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "+", 
     RowBox[{"3", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "+", 
     RowBox[{"3", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "+", 
     RowBox[{"5", " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "-", 
     RowBox[{
      SubsuperscriptBox["z", "1", "2"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"3", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "-", 
     RowBox[{"3", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"6", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "-", 
     RowBox[{"2", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"5", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "-", 
     RowBox[{
      SubsuperscriptBox["z", "1", "2"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "+", 
     RowBox[{"3", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "+", 
     RowBox[{
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "-", 
     RowBox[{"2", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "+", 
     RowBox[{"5", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "-", 
     RowBox[{"8", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "+", 
     RowBox[{"11", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "4"]}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.805703289404414*^9, 
  3.805703301431094*^9}},ExpressionUUID->"0c292332-5440-4480-afc6-\
cb310e5d8c83"],

Cell["Corresponding Inhomogeneity", "Text",
 CellChangeTimes->{{3.805698576477152*^9, 
  3.805698588439147*^9}},ExpressionUUID->"885ed052-3b3e-4cc1-a30e-\
1dfce8723feb"],

Cell[BoxData[
 RowBox[{"5", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"Log", "[", 
     SubscriptBox["z", "1"], "]"}], "-", 
    RowBox[{"Log", "[", 
     SubscriptBox["z", "2"], "]"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.805699014334144*^9, 3.8056990170000877`*^9}, {
  3.805703214243043*^9, 3.8057032264135942`*^9}, {3.805703261087371*^9, 
  3.805703265891156*^9}, {3.805703315426671*^9, 
  3.805703323852167*^9}},ExpressionUUID->"8c4dfd46-f512-4b10-9a8d-\
4527c6f1e7a8"],

Cell["Inhomogeneous Differential equation", "Text",
 CellChangeTimes->{{3.805698375392599*^9, 
  3.8056983922982073`*^9}},ExpressionUUID->"30a92257-0afa-40a0-9ed1-\
52bb7adc1f09"],

Cell[BoxData[
 RowBox[{
  RowBox[{"3", " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "-", 
  RowBox[{"3", " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  SubsuperscriptBox["\[Theta]", "4", "2"], "+", 
  RowBox[{"3", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "-", 
  RowBox[{
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "-", 
  RowBox[{"3", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "-", 
  RowBox[{
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{"3", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{"3", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "-", 
  RowBox[{"3", " ", 
   SubscriptBox["z", "1"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "-", 
  RowBox[{"3", " ", 
   SubscriptBox["z", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "+", 
  RowBox[{"3", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"3", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"3", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"3", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"2", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"8", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"5", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"8", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["z", "1"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "+", 
  RowBox[{"8", " ", 
   SubscriptBox["z", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "-", 
  RowBox[{
   SubscriptBox["z", "3"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "+", 
  RowBox[{
   SubscriptBox["z", "4"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "-", 
  RowBox[{"2", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "3"}], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "3"]}], "-", 
     RowBox[{
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "4"]}], "-", 
     RowBox[{"4", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "4"]}], "+", 
     RowBox[{"2", " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "4"]}], "+", 
     RowBox[{"3", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "-", 
     RowBox[{"3", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "-", 
     RowBox[{"4", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "-", 
     RowBox[{
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "-", 
     RowBox[{"4", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "-", 
     RowBox[{
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "-", 
     RowBox[{"4", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "+", 
     RowBox[{"2", " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "4"]}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.805703364071691*^9, 
  3.805703373355101*^9}},ExpressionUUID->"76dd2063-48bd-471c-b796-\
006f00518e6b"],

Cell["Corresponding Inhomogeneity", "Text",
 CellChangeTimes->{{3.805698576477152*^9, 
  3.805698588439147*^9}},ExpressionUUID->"1ba86d85-3757-4d42-835f-\
4b79408de474"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Log", "[", 
   SubscriptBox["z", "1"], "]"}], "+", 
  RowBox[{"Log", "[", 
   SubscriptBox["z", "2"], "]"}], "+", 
  RowBox[{"Log", "[", 
   SubscriptBox["z", "3"], "]"}], "-", 
  RowBox[{"3", 
   RowBox[{"Log", "[", 
    SubscriptBox["z", "4"], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.805699014334144*^9, 3.8056990170000877`*^9}, {
  3.805703214243043*^9, 3.8057032264135942`*^9}, {3.805703261087371*^9, 
  3.805703265891156*^9}, {3.805703315426671*^9, 3.805703323852167*^9}, {
  3.805703384639276*^9, 
  3.805703399442237*^9}},ExpressionUUID->"2dc2303d-cc2b-4bd4-9603-\
62a091db59ae"],

Cell["Inhomogeneous Differential equation", "Text",
 CellChangeTimes->{{3.805698375392599*^9, 
  3.8056983922982073`*^9}},ExpressionUUID->"52410f5a-e190-4374-beeb-\
bd286a0802e2"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", 
    SubscriptBox["\[Theta]", "2"]}], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Theta]", "2"], "+", 
     RowBox[{"5", " ", 
      SubscriptBox["\[Theta]", "3"]}], "-", 
     RowBox[{"5", " ", 
      SubscriptBox["\[Theta]", "4"]}]}], ")"}]}], "+", 
  RowBox[{
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "+", 
  RowBox[{"2", " ", 
   SubscriptBox["z", "1"], " ", 
   SubsuperscriptBox["\[Theta]", "1", "2"]}], "+", 
  RowBox[{"5", " ", 
   SubscriptBox["z", "4"], " ", 
   SubsuperscriptBox["\[Theta]", "1", "2"]}], "-", 
  RowBox[{
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "-", 
  RowBox[{"3", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{"3", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{
   SubscriptBox["z", "1"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "-", 
  RowBox[{"3", " ", 
   SubscriptBox["z", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "-", 
  RowBox[{"5", " ", 
   SubscriptBox["z", "4"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "+", 
  RowBox[{
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"13", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"4", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"14", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"10", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{
   SubscriptBox["z", "1"], " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "+", 
  RowBox[{"17", " ", 
   SubscriptBox["z", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "-", 
  RowBox[{"5", " ", 
   SubscriptBox["z", "4"], " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "+", 
  RowBox[{
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"4", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"12", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"5", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"5", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"11", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"5", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"5", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"3", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"5", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"5", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"5", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"6", " ", 
   SubscriptBox["z", "1"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "-", 
  RowBox[{"8", " ", 
   SubscriptBox["z", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "+", 
  RowBox[{"5", " ", 
   SubscriptBox["z", "3"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"2", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"]}], "+", 
     RowBox[{"12", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "3"]}], "-", 
     RowBox[{"8", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "4"]}], "+", 
     RowBox[{"2", " ", 
      SubsuperscriptBox["z", "1", "2"], " ", 
      SubscriptBox["\[Theta]", "1"]}], "-", 
     RowBox[{
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["\[Theta]", "1"]}], "+", 
     RowBox[{"2", " ", 
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["\[Theta]", "1"]}], "+", 
     RowBox[{
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "1"]}], "+", 
     RowBox[{"11", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "1"]}], "-", 
     RowBox[{"2", " ", 
      SubsuperscriptBox["z", "1", "2"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "+", 
     RowBox[{"3", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "-", 
     RowBox[{"2", " ", 
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "+", 
     RowBox[{"11", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "-", 
     RowBox[{"10", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "-", 
     RowBox[{"9", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "-", 
     RowBox[{"2", " ", 
      SubsuperscriptBox["z", "1", "2"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"11", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"2", " ", 
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "-", 
     RowBox[{
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"22", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"10", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "-", 
     RowBox[{"10", " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "-", 
     RowBox[{"2", " ", 
      SubsuperscriptBox["z", "1", "2"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "-", 
     RowBox[{"9", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "+", 
     RowBox[{"2", " ", 
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "+", 
     RowBox[{
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "-", 
     RowBox[{"10", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "-", 
     RowBox[{"11", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "-", 
     RowBox[{"8", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "+", 
     RowBox[{"10", " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "4"]}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{{3.8057031519039593`*^9, 
  3.805703160333671*^9}},ExpressionUUID->"e09ef6be-f445-487d-ae29-\
73c5896db44c"],

Cell["Corresponding Inhomogeneity", "Text",
 CellChangeTimes->{{3.805698576477152*^9, 
  3.805698588439147*^9}},ExpressionUUID->"0648d9fc-6841-4298-a0cc-\
92f17e9bf618"],

Cell[BoxData[
 RowBox[{"5", 
  RowBox[{"(", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{"Log", "[", 
      SubscriptBox["z", "3"], "]"}]}], "+", 
    RowBox[{"Log", "[", 
     SubscriptBox["z", "4"], "]"}]}], ")"}]}]], "Input",
 CellChangeTimes->{{3.805699014334144*^9, 3.8056990170000877`*^9}, {
  3.805703214243043*^9, 3.8057032264135942`*^9}, {3.805703261087371*^9, 
  3.805703265891156*^9}},ExpressionUUID->"998ca03f-9f46-4645-804f-\
b2742bf27609"]
}, Closed]],

Cell[CellGroupData[{

Cell["Four - Loop Banana Non - Equal Mass Differential Equations", "Chapter",
 CellChangeTimes->{{3.805697023549979*^9, 3.8056970273107452`*^9}, {
  3.8056974266246634`*^9, 
  3.805697428166109*^9}},ExpressionUUID->"467a2f02-2ef3-4904-86d7-\
64bbb774f9c7"],

Cell["Homogeneous Operators", "Text",
 CellChangeTimes->{{3.805703049496501*^9, 
  3.805703051195733*^9}},ExpressionUUID->"ad2738a3-8420-4e22-be2e-\
a6826af37d32"],

Cell[BoxData[{
 RowBox[{
  SubsuperscriptBox["\[Theta]", "1", "2"], "-", 
  RowBox[{
   SubscriptBox["z", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", 
      SubscriptBox["\[Theta]", "1"]}], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"], "+", 
     SubscriptBox["\[Theta]", "5"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"], "+", 
     SubscriptBox["\[Theta]", "5"]}], ")"}]}], "-", 
  RowBox[{
   SubscriptBox["z", "1"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["z", "2"], "+", 
     SubscriptBox["z", "3"], "+", 
     SubscriptBox["z", "4"], "+", 
     SubscriptBox["z", "5"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"], "+", 
     SubscriptBox["\[Theta]", "5"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"], "+", 
     SubscriptBox["\[Theta]", "5"]}], ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubsuperscriptBox["\[Theta]", "2", "2"], "-", 
  RowBox[{
   SubscriptBox["z", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Theta]", "1"], "-", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"], "+", 
     SubscriptBox["\[Theta]", "5"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"], "+", 
     SubscriptBox["\[Theta]", "5"]}], ")"}]}], "-", 
  RowBox[{
   SubscriptBox["z", "2"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["z", "1"], "+", 
     SubscriptBox["z", "3"], "+", 
     SubscriptBox["z", "4"], "+", 
     SubscriptBox["z", "5"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"], "+", 
     SubscriptBox["\[Theta]", "5"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"], "+", 
     SubscriptBox["\[Theta]", "5"]}], ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubsuperscriptBox["\[Theta]", "3", "2"], "-", 
  RowBox[{
   SubscriptBox["z", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "-", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"], "+", 
     SubscriptBox["\[Theta]", "5"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"], "+", 
     SubscriptBox["\[Theta]", "5"]}], ")"}]}], "-", 
  RowBox[{
   SubscriptBox["z", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["z", "1"], "+", 
     SubscriptBox["z", "2"], "+", 
     SubscriptBox["z", "4"], "+", 
     SubscriptBox["z", "5"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"], "+", 
     SubscriptBox["\[Theta]", "5"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"], "+", 
     SubscriptBox["\[Theta]", "5"]}], ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubsuperscriptBox["\[Theta]", "4", "2"], "-", 
  RowBox[{
   SubscriptBox["z", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "-", 
     SubscriptBox["\[Theta]", "4"], "+", 
     SubscriptBox["\[Theta]", "5"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"], "+", 
     SubscriptBox["\[Theta]", "5"]}], ")"}]}], "-", 
  RowBox[{
   SubscriptBox["z", "4"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["z", "1"], "+", 
     SubscriptBox["z", "2"], "+", 
     SubscriptBox["z", "3"], "+", 
     SubscriptBox["z", "5"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"], "+", 
     SubscriptBox["\[Theta]", "5"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"], "+", 
     SubscriptBox["\[Theta]", "5"]}], ")"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  SubsuperscriptBox["\[Theta]", "5", "2"], "-", 
  RowBox[{
   SubscriptBox["z", "5"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"], "-", 
     SubscriptBox["\[Theta]", "5"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"], "+", 
     SubscriptBox["\[Theta]", "5"]}], ")"}]}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["z", "1"], "+", 
     SubscriptBox["z", "2"], "+", 
     SubscriptBox["z", "3"], "+", 
     SubscriptBox["z", "4"]}], ")"}], " ", 
   SubscriptBox["z", "5"], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"], "+", 
     SubscriptBox["\[Theta]", "5"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"], "+", 
     SubscriptBox["\[Theta]", "5"]}], ")"}]}]}]}], "Input",
 CellChangeTimes->{{3.805703426083427*^9, 
  3.805703437412057*^9}},ExpressionUUID->"3fa1e548-ce6d-4cb1-a1e9-\
21e087632de4"],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{
  3.805698573802699*^9},ExpressionUUID->"58f47a24-1ee3-4486-a866-\
ebcb3ed10058"],

Cell["Inhomogeneous Differential equation", "Text",
 CellChangeTimes->{{3.805698375392599*^9, 
  3.8056983922982073`*^9}},ExpressionUUID->"62c8bda0-9e7b-4dd5-9b71-\
26d7cb025bea"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"-", "63"}], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "-", 
  RowBox[{"416", " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"13", " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"206", " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "-", 
  RowBox[{"180", " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"102", " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"507", " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"180", " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "+", 
  RowBox[{"596", " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"89", " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"78", " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"429", " ", 
   SubscriptBox["\[Theta]", "4"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"323", " ", 
   SubsuperscriptBox["\[Theta]", "5", "2"]}], "+", 
  RowBox[{"63", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "-", 
  RowBox[{"206", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "-", 
  RowBox[{"180", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "+", 
  RowBox[{"323", " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "-", 
  RowBox[{"63", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "-", 
  RowBox[{"206", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "-", 
  RowBox[{"180", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{"323", " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "-", 
  RowBox[{"42", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{"168", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "-", 
  RowBox[{"84", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{"42", " ", 
   SubscriptBox["z", "1"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "-", 
  RowBox[{"168", " ", 
   SubscriptBox["z", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "-", 
  RowBox[{"277", " ", 
   SubscriptBox["z", "3"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "-", 
  RowBox[{"282", " ", 
   SubscriptBox["z", "4"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "+", 
  RowBox[{"139", " ", 
   SubscriptBox["z", "5"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "+", 
  RowBox[{"63", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"206", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"180", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"323", " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"972", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"422", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"311", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"702", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"949", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"190", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"34", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"984", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"685", " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"972", " ", 
   SubscriptBox["z", "1"], " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "-", 
  RowBox[{"22", " ", 
   SubscriptBox["z", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "+", 
  RowBox[{"311", " ", 
   SubscriptBox["z", "3"], " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "-", 
  RowBox[{"435", " ", 
   SubscriptBox["z", "4"], " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "+", 
  RowBox[{"6", " ", 
   SubscriptBox["z", "5"], " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "+", 
  RowBox[{"63", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"206", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"180", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"323", " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"360", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"321", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"698", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"180", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"1019", " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"303", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"270", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"1101", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"102", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"1158", " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"718", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"440", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"914", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"255", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"1014", " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"360", " ", 
   SubscriptBox["z", "1"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "-", 
  RowBox[{"102", " ", 
   SubscriptBox["z", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "-", 
  RowBox[{"1225", " ", 
   SubscriptBox["z", "3"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "+", 
  RowBox[{"180", " ", 
   SubscriptBox["z", "4"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "+", 
  RowBox[{"1147", " ", 
   SubscriptBox["z", "5"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "+", 
  RowBox[{"63", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"206", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"180", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"323", " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"1374", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"109", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"273", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"18", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"323", " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"1210", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"628", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"4", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"300", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"184", " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"279", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"219", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"569", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"156", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"317", " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"481", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["\[Theta]", "4"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"767", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "4"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"858", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "4"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"177", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "4"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"824", " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "4"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"1374", " ", 
   SubscriptBox["z", "1"], " ", 
   SubsuperscriptBox["\[Theta]", "5", "2"]}], "+", 
  RowBox[{"796", " ", 
   SubscriptBox["z", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "5", "2"]}], "+", 
  RowBox[{"258", " ", 
   SubscriptBox["z", "3"], " ", 
   SubsuperscriptBox["\[Theta]", "5", "2"]}], "-", 
  RowBox[{"3", " ", 
   SubscriptBox["z", "4"], " ", 
   SubsuperscriptBox["\[Theta]", "5", "2"]}], "-", 
  RowBox[{"323", " ", 
   SubscriptBox["z", "5"], " ", 
   SubsuperscriptBox["\[Theta]", "5", "2"]}], "+", 
  RowBox[{"126", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "2"]}], "+", 
  RowBox[{"420", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "3"]}], "-", 
  RowBox[{"260", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "3"]}], "-", 
  RowBox[{"438", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "4"]}], "-", 
  RowBox[{"1786", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "4"]}], "-", 
  RowBox[{"546", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "5"]}], "+", 
  RowBox[{"950", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "5"]}], "+", 
  RowBox[{"390", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "5"]}], "+", 
  RowBox[{"1144", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["z", "5"]}], "+", 
  RowBox[{"84", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "+", 
  RowBox[{"105", " ", 
   SubsuperscriptBox["z", "2", "2"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "-", 
  RowBox[{"136", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "+", 
  RowBox[{"624", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "-", 
  RowBox[{"105", " ", 
   SubsuperscriptBox["z", "3", "2"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "-", 
  RowBox[{"180", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "-", 
  RowBox[{"234", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "-", 
  RowBox[{"1227", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "+", 
  RowBox[{"232", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "-", 
  RowBox[{"138", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "+", 
  RowBox[{"234", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "+", 
  RowBox[{"741", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "1"]}], "-", 
  RowBox[{"105", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "1", "2"]}], "-", 
  RowBox[{"273", " ", 
   SubsuperscriptBox["z", "2", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "1", "2"]}], "+", 
  RowBox[{"105", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubsuperscriptBox["\[Theta]", "1", "2"]}], "+", 
  RowBox[{"273", " ", 
   SubsuperscriptBox["z", "5", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "1", "2"]}], "+", 
  RowBox[{"294", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "-", 
  RowBox[{"105", " ", 
   SubsuperscriptBox["z", "2", "2"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{"310", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "-", 
  RowBox[{"376", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "-", 
  RowBox[{"105", " ", 
   SubsuperscriptBox["z", "3", "2"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "-", 
  RowBox[{"384", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "-", 
  RowBox[{"594", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "-", 
  RowBox[{"2597", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "-", 
  RowBox[{"136", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{"508", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{"798", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{"1547", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "-", 
  RowBox[{"42", " ", 
   SubsuperscriptBox["z", "1", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{"252", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{"168", " ", 
   SubsuperscriptBox["z", "2", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "-", 
  RowBox[{"744", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{"181", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "-", 
  RowBox[{"294", " ", 
   SubsuperscriptBox["z", "3", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "-", 
  RowBox[{"225", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{"507", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{"168", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{"885", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "-", 
  RowBox[{"1024", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "2"]}], "+", 
  RowBox[{"42", " ", 
   SubsuperscriptBox["z", "1", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "+", 
  RowBox[{"105", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "+", 
  RowBox[{"105", " ", 
   SubsuperscriptBox["z", "2", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "+", 
  RowBox[{"97", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "-", 
  RowBox[{"101", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "+", 
  RowBox[{"126", " ", 
   SubsuperscriptBox["z", "3", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "-", 
  RowBox[{"522", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "+", 
  RowBox[{"240", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "-", 
  RowBox[{"269", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "-", 
  RowBox[{"226", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "-", 
  RowBox[{"727", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "-", 
  RowBox[{"1497", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "+", 
  RowBox[{"632", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "-", 
  RowBox[{"273", " ", 
   SubsuperscriptBox["z", "5", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "2", "2"]}], "+", 
  RowBox[{"1068", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"105", " ", 
   SubsuperscriptBox["z", "2", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"1396", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"404", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"105", " ", 
   SubsuperscriptBox["z", "3", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"362", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"1582", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"1915", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"674", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"1236", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"196", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"715", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"556", " ", 
   SubsuperscriptBox["z", "1", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"692", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"161", " ", 
   SubsuperscriptBox["z", "2", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"31", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"1145", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"105", " ", 
   SubsuperscriptBox["z", "3", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"499", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"385", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"203", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"252", " ", 
   SubsuperscriptBox["z", "4", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"1191", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"420", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"570", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"1248", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"122", " ", 
   SubsuperscriptBox["z", "5", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"598", " ", 
   SubsuperscriptBox["z", "1", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"1192", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"203", " ", 
   SubsuperscriptBox["z", "2", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"1395", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"78", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"21", " ", 
   SubsuperscriptBox["z", "3", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"1258", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"1006", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"1167", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"252", " ", 
   SubsuperscriptBox["z", "4", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"2610", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"264", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"132", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"104", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "-", 
  RowBox[{"668", " ", 
   SubsuperscriptBox["z", "5", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "3"]}], "+", 
  RowBox[{"556", " ", 
   SubsuperscriptBox["z", "1", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "-", 
  RowBox[{"383", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "-", 
  RowBox[{"308", " ", 
   SubsuperscriptBox["z", "2", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "+", 
  RowBox[{"766", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "-", 
  RowBox[{"341", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "-", 
  RowBox[{"105", " ", 
   SubsuperscriptBox["z", "3", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "+", 
  RowBox[{"804", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "+", 
  RowBox[{"84", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "-", 
  RowBox[{"566", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "+", 
  RowBox[{"252", " ", 
   SubsuperscriptBox["z", "4", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "+", 
  RowBox[{"438", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "-", 
  RowBox[{"567", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "-", 
  RowBox[{"897", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "-", 
  RowBox[{"1438", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "-", 
  RowBox[{"395", " ", 
   SubsuperscriptBox["z", "5", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "3", "2"]}], "+", 
  RowBox[{"366", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"105", " ", 
   SubsuperscriptBox["z", "2", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"370", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"1426", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"105", " ", 
   SubsuperscriptBox["z", "3", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"180", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"720", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"3443", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"904", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"1708", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"438", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"2363", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"180", " ", 
   SubsuperscriptBox["z", "1", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"228", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"126", " ", 
   SubsuperscriptBox["z", "2", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"1107", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"208", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"722", " ", 
   SubsuperscriptBox["z", "3", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"180", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"705", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"1026", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"2055", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"733", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"15", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"1371", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"668", " ", 
   SubsuperscriptBox["z", "5", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"222", " ", 
   SubsuperscriptBox["z", "1", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"708", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"168", " ", 
   SubsuperscriptBox["z", "2", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"1259", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"1203", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"596", " ", 
   SubsuperscriptBox["z", "3", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"363", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"270", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"2396", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"2138", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"195", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"423", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"1631", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"122", " ", 
   SubsuperscriptBox["z", "5", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"736", " ", 
   SubsuperscriptBox["z", "1", "2"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"588", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"161", " ", 
   SubsuperscriptBox["z", "2", "2"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"398", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"1571", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"407", " ", 
   SubsuperscriptBox["z", "3", "2"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"45", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"1888", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"1631", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"252", " ", 
   SubsuperscriptBox["z", "4", "2"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"2422", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"533", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "-", 
  RowBox[{"169", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"117", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "4"]}], "+", 
  RowBox[{"180", " ", 
   SubsuperscriptBox["z", "1", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "+", 
  RowBox[{"498", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "-", 
  RowBox[{"273", " ", 
   SubsuperscriptBox["z", "2", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "-", 
  RowBox[{"867", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "-", 
  RowBox[{"1380", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "-", 
  RowBox[{"302", " ", 
   SubsuperscriptBox["z", "3", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "+", 
  RowBox[{"180", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "-", 
  RowBox[{"846", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "-", 
  RowBox[{"1375", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "+", 
  RowBox[{"1089", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "+", 
  RowBox[{"120", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "+", 
  RowBox[{"1080", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "+", 
  RowBox[{"1501", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "+", 
  RowBox[{"395", " ", 
   SubsuperscriptBox["z", "5", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "4", "2"]}], "-", 
  RowBox[{"804", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"105", " ", 
   SubsuperscriptBox["z", "2", "2"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"752", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"126", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"105", " ", 
   SubsuperscriptBox["z", "3", "2"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"514", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"442", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"1405", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"1870", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"2342", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"1366", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"1069", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"778", " ", 
   SubsuperscriptBox["z", "1", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"422", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"581", " ", 
   SubsuperscriptBox["z", "2", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"882", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"780", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"176", " ", 
   SubsuperscriptBox["z", "3", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"716", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"760", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"885", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"252", " ", 
   SubsuperscriptBox["z", "4", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"41", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"64", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"744", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"890", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"273", " ", 
   SubsuperscriptBox["z", "5", "2"], " ", 
   SubscriptBox["\[Theta]", "1"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"736", " ", 
   SubsuperscriptBox["z", "1", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"1438", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"539", " ", 
   SubsuperscriptBox["z", "2", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"1806", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"393", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"302", " ", 
   SubsuperscriptBox["z", "3", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"971", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"365", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"485", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"252", " ", 
   SubsuperscriptBox["z", "4", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"1116", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"684", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"1434", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"462", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"273", " ", 
   SubsuperscriptBox["z", "5", "2"], " ", 
   SubscriptBox["\[Theta]", "2"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"222", " ", 
   SubsuperscriptBox["z", "1", "2"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"84", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"546", " ", 
   SubsuperscriptBox["z", "2", "2"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"591", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"63", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"491", " ", 
   SubsuperscriptBox["z", "3", "2"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"651", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"159", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"144", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"198", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"1524", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"294", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"312", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"395", " ", 
   SubsuperscriptBox["z", "5", "2"], " ", 
   SubscriptBox["\[Theta]", "3"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"598", " ", 
   SubsuperscriptBox["z", "1", "2"], " ", 
   SubscriptBox["\[Theta]", "4"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"252", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["\[Theta]", "4"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"581", " ", 
   SubsuperscriptBox["z", "2", "2"], " ", 
   SubscriptBox["\[Theta]", "4"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"1981", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "4"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"416", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["\[Theta]", "4"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"126", " ", 
   SubsuperscriptBox["z", "3", "2"], " ", 
   SubscriptBox["\[Theta]", "4"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"132", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "4"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"1519", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "4"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"1323", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["\[Theta]", "4"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"252", " ", 
   SubsuperscriptBox["z", "4", "2"], " ", 
   SubscriptBox["\[Theta]", "4"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"206", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "4"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"2537", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "4"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"751", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "4"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "+", 
  RowBox[{"1001", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubscriptBox["\[Theta]", "4"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"395", " ", 
   SubsuperscriptBox["z", "5", "2"], " ", 
   SubscriptBox["\[Theta]", "4"], " ", 
   SubscriptBox["\[Theta]", "5"]}], "-", 
  RowBox[{"778", " ", 
   SubsuperscriptBox["z", "1", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "5", "2"]}], "+", 
  RowBox[{"1040", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "5", "2"]}], "+", 
  RowBox[{"434", " ", 
   SubsuperscriptBox["z", "2", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "5", "2"]}], "-", 
  RowBox[{"606", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubsuperscriptBox["\[Theta]", "5", "2"]}], "+", 
  RowBox[{"2784", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "3"], " ", 
   SubsuperscriptBox["\[Theta]", "5", "2"]}], "+", 
  RowBox[{"596", " ", 
   SubsuperscriptBox["z", "3", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "5", "2"]}], "-", 
  RowBox[{"1362", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubsuperscriptBox["\[Theta]", "5", "2"]}], "+", 
  RowBox[{"597", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubsuperscriptBox["\[Theta]", "5", "2"]}], "-", 
  RowBox[{"146", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "4"], " ", 
   SubsuperscriptBox["\[Theta]", "5", "2"]}], "-", 
  RowBox[{"252", " ", 
   SubsuperscriptBox["z", "4", "2"], " ", 
   SubsuperscriptBox["\[Theta]", "5", "2"]}], "-", 
  RowBox[{"1051", " ", 
   SubscriptBox["z", "1"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubsuperscriptBox["\[Theta]", "5", "2"]}], "+", 
  RowBox[{"1943", " ", 
   SubscriptBox["z", "2"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubsuperscriptBox["\[Theta]", "5", "2"]}], "+", 
  RowBox[{"1383", " ", 
   SubscriptBox["z", "3"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubsuperscriptBox["\[Theta]", "5", "2"]}], "-", 
  RowBox[{"214", " ", 
   SubscriptBox["z", "4"], " ", 
   SubscriptBox["z", "5"], " ", 
   SubsuperscriptBox["\[Theta]", "5", "2"]}], "-", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"], "+", 
     SubscriptBox["\[Theta]", "5"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{
     RowBox[{"105", " ", 
      SubsuperscriptBox["z", "1", "2"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["\[Theta]", "1"]}], "+", 
     RowBox[{"315", " ", 
      SubscriptBox["z", "1"], " ", 
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["\[Theta]", "1"]}], "+", 
     RowBox[{"210", " ", 
      SubsuperscriptBox["z", "2", "3"], " ", 
      SubscriptBox["\[Theta]", "1"]}], "-", 
     RowBox[{"105", " ", 
      SubsuperscriptBox["z", "1", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "1"]}], "-", 
     RowBox[{"364", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "1"]}], "+", 
     RowBox[{"910", " ", 
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "1"]}], "-", 
     RowBox[{"315", " ", 
      SubscriptBox["z", "1"], " ", 
      SubsuperscriptBox["z", "3", "2"], " ", 
      SubscriptBox["\[Theta]", "1"]}], "-", 
     RowBox[{"210", " ", 
      SubsuperscriptBox["z", "3", "3"], " ", 
      SubscriptBox["\[Theta]", "1"]}], "+", 
     RowBox[{"126", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "1"]}], "+", 
     RowBox[{"420", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "1"]}], "+", 
     RowBox[{"490", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "1"]}], "-", 
     RowBox[{"910", " ", 
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "1"]}], "-", 
     RowBox[{"126", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "1"]}], "-", 
     RowBox[{"546", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "1"]}], "-", 
     RowBox[{"105", " ", 
      SubsuperscriptBox["z", "1", "2"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "-", 
     RowBox[{"315", " ", 
      SubscriptBox["z", "1"], " ", 
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "-", 
     RowBox[{"210", " ", 
      SubsuperscriptBox["z", "2", "3"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "+", 
     RowBox[{"1087", " ", 
      SubsuperscriptBox["z", "1", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "-", 
     RowBox[{"1108", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "-", 
     RowBox[{"428", " ", 
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "-", 
     RowBox[{"139", " ", 
      SubscriptBox["z", "1"], " ", 
      SubsuperscriptBox["z", "3", "2"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "-", 
     RowBox[{"428", " ", 
      SubscriptBox["z", "2"], " ", 
      SubsuperscriptBox["z", "3", "2"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "-", 
     RowBox[{"210", " ", 
      SubsuperscriptBox["z", "3", "3"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "+", 
     RowBox[{"162", " ", 
      SubsuperscriptBox["z", "1", "2"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "+", 
     RowBox[{"174", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "-", 
     RowBox[{"774", " ", 
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "+", 
     RowBox[{"1608", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "+", 
     RowBox[{"260", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "-", 
     RowBox[{"252", " ", 
      SubsuperscriptBox["z", "3", "2"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "+", 
     RowBox[{"564", " ", 
      SubscriptBox["z", "1"], " ", 
      SubsuperscriptBox["z", "4", "2"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "-", 
     RowBox[{"564", " ", 
      SubscriptBox["z", "2"], " ", 
      SubsuperscriptBox["z", "4", "2"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "-", 
     RowBox[{"1312", " ", 
      SubsuperscriptBox["z", "1", "2"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "+", 
     RowBox[{"2740", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "+", 
     RowBox[{"614", " ", 
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "-", 
     RowBox[{"396", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "+", 
     RowBox[{"2760", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "-", 
     RowBox[{"1632", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "-", 
     RowBox[{"584", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "-", 
     RowBox[{"840", " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "+", 
     RowBox[{"268", " ", 
      SubscriptBox["z", "1"], " ", 
      SubsuperscriptBox["z", "5", "2"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "+", 
     RowBox[{"824", " ", 
      SubscriptBox["z", "2"], " ", 
      SubsuperscriptBox["z", "5", "2"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "+", 
     RowBox[{"1092", " ", 
      SubscriptBox["z", "3"], " ", 
      SubsuperscriptBox["z", "5", "2"], " ", 
      SubscriptBox["\[Theta]", "2"]}], "-", 
     RowBox[{"151", " ", 
      SubsuperscriptBox["z", "1", "2"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"867", " ", 
      SubscriptBox["z", "1"], " ", 
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"210", " ", 
      SubsuperscriptBox["z", "2", "3"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"105", " ", 
      SubsuperscriptBox["z", "1", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"614", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"428", " ", 
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"315", " ", 
      SubscriptBox["z", "1"], " ", 
      SubsuperscriptBox["z", "3", "2"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"428", " ", 
      SubscriptBox["z", "2"], " ", 
      SubsuperscriptBox["z", "3", "2"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"210", " ", 
      SubsuperscriptBox["z", "3", "3"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "-", 
     RowBox[{"868", " ", 
      SubsuperscriptBox["z", "1", "2"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"898", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "-", 
     RowBox[{"194", " ", 
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "-", 
     RowBox[{"1168", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "-", 
     RowBox[{"518", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"240", " ", 
      SubsuperscriptBox["z", "3", "2"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "-", 
     RowBox[{"534", " ", 
      SubscriptBox["z", "1"], " ", 
      SubsuperscriptBox["z", "4", "2"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "-", 
     RowBox[{"1098", " ", 
      SubscriptBox["z", "2"], " ", 
      SubsuperscriptBox["z", "4", "2"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"30", " ", 
      SubscriptBox["z", "3"], " ", 
      SubsuperscriptBox["z", "4", "2"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "-", 
     RowBox[{"1310", " ", 
      SubsuperscriptBox["z", "1", "2"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"1608", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "-", 
     RowBox[{"646", " ", 
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"1114", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"956", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"1012", " ", 
      SubsuperscriptBox["z", "3", "2"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "-", 
     RowBox[{"344", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "-", 
     RowBox[{"902", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"1312", " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"594", " ", 
      SubsuperscriptBox["z", "4", "2"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"534", " ", 
      SubscriptBox["z", "1"], " ", 
      SubsuperscriptBox["z", "5", "2"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"1358", " ", 
      SubscriptBox["z", "2"], " ", 
      SubsuperscriptBox["z", "5", "2"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "+", 
     RowBox[{"802", " ", 
      SubscriptBox["z", "3"], " ", 
      SubsuperscriptBox["z", "5", "2"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "-", 
     RowBox[{"22", " ", 
      SubscriptBox["z", "4"], " ", 
      SubsuperscriptBox["z", "5", "2"], " ", 
      SubscriptBox["\[Theta]", "3"]}], "-", 
     RowBox[{"219", " ", 
      SubsuperscriptBox["z", "1", "2"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "-", 
     RowBox[{"459", " ", 
      SubscriptBox["z", "1"], " ", 
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "+", 
     RowBox[{"210", " ", 
      SubsuperscriptBox["z", "2", "3"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "-", 
     RowBox[{"11", " ", 
      SubsuperscriptBox["z", "1", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "-", 
     RowBox[{"2506", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "-", 
     RowBox[{"610", " ", 
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "+", 
     RowBox[{"529", " ", 
      SubscriptBox["z", "1"], " ", 
      SubsuperscriptBox["z", "3", "2"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "+", 
     RowBox[{"416", " ", 
      SubscriptBox["z", "2"], " ", 
      SubsuperscriptBox["z", "3", "2"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "-", 
     RowBox[{"210", " ", 
      SubsuperscriptBox["z", "3", "3"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "-", 
     RowBox[{"36", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "+", 
     RowBox[{"774", " ", 
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "+", 
     RowBox[{"150", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "+", 
     RowBox[{"1450", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "-", 
     RowBox[{"240", " ", 
      SubsuperscriptBox["z", "3", "2"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "+", 
     RowBox[{"564", " ", 
      SubscriptBox["z", "2"], " ", 
      SubsuperscriptBox["z", "4", "2"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "-", 
     RowBox[{"30", " ", 
      SubscriptBox["z", "3"], " ", 
      SubsuperscriptBox["z", "4", "2"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "-", 
     RowBox[{"490", " ", 
      SubsuperscriptBox["z", "1", "2"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "+", 
     RowBox[{"2506", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "+", 
     RowBox[{"610", " ", 
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "+", 
     RowBox[{"360", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "-", 
     RowBox[{"360", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "+", 
     RowBox[{"188", " ", 
      SubsuperscriptBox["z", "3", "2"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "-", 
     RowBox[{"114", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "+", 
     RowBox[{"554", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "-", 
     RowBox[{"2004", " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "-", 
     RowBox[{"534", " ", 
      SubsuperscriptBox["z", "4", "2"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "+", 
     RowBox[{"290", " ", 
      SubscriptBox["z", "1"], " ", 
      SubsuperscriptBox["z", "5", "2"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "+", 
     RowBox[{"22", " ", 
      SubscriptBox["z", "2"], " ", 
      SubsuperscriptBox["z", "5", "2"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "-", 
     RowBox[{"266", " ", 
      SubscriptBox["z", "3"], " ", 
      SubsuperscriptBox["z", "5", "2"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "-", 
     RowBox[{"534", " ", 
      SubscriptBox["z", "4"], " ", 
      SubsuperscriptBox["z", "5", "2"], " ", 
      SubscriptBox["\[Theta]", "4"]}], "+", 
     RowBox[{"223", " ", 
      SubsuperscriptBox["z", "1", "2"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "-", 
     RowBox[{"1395", " ", 
      SubscriptBox["z", "1"], " ", 
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "+", 
     RowBox[{"210", " ", 
      SubsuperscriptBox["z", "2", "3"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "+", 
     RowBox[{"1463", " ", 
      SubsuperscriptBox["z", "1", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "-", 
     RowBox[{"1212", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "-", 
     RowBox[{"1088", " ", 
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "-", 
     RowBox[{"495", " ", 
      SubscriptBox["z", "1"], " ", 
      SubsuperscriptBox["z", "3", "2"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "-", 
     RowBox[{"356", " ", 
      SubscriptBox["z", "2"], " ", 
      SubsuperscriptBox["z", "3", "2"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "-", 
     RowBox[{"210", " ", 
      SubsuperscriptBox["z", "3", "3"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "+", 
     RowBox[{"1426", " ", 
      SubsuperscriptBox["z", "1", "2"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "-", 
     RowBox[{"1294", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "+", 
     RowBox[{"584", " ", 
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "+", 
     RowBox[{"404", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "+", 
     RowBox[{"2102", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "-", 
     RowBox[{"836", " ", 
      SubsuperscriptBox["z", "3", "2"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "-", 
     RowBox[{"30", " ", 
      SubscriptBox["z", "1"], " ", 
      SubsuperscriptBox["z", "4", "2"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "-", 
     RowBox[{"594", " ", 
      SubscriptBox["z", "2"], " ", 
      SubsuperscriptBox["z", "4", "2"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "+", 
     RowBox[{"1098", " ", 
      SubscriptBox["z", "3"], " ", 
      SubsuperscriptBox["z", "4", "2"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "-", 
     RowBox[{"1796", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "-", 
     RowBox[{"614", " ", 
      SubsuperscriptBox["z", "2", "2"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "-", 
     RowBox[{"1204", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "-", 
     RowBox[{"4076", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "-", 
     RowBox[{"1012", " ", 
      SubsuperscriptBox["z", "3", "2"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "+", 
     RowBox[{"634", " ", 
      SubscriptBox["z", "1"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "-", 
     RowBox[{"382", " ", 
      SubscriptBox["z", "2"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "+", 
     RowBox[{"272", " ", 
      SubscriptBox["z", "3"], " ", 
      SubscriptBox["z", "4"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "+", 
     RowBox[{"534", " ", 
      SubsuperscriptBox["z", "4", "2"], " ", 
      SubscriptBox["z", "5"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "-", 
     RowBox[{"824", " ", 
      SubscriptBox["z", "2"], " ", 
      SubsuperscriptBox["z", "5", "2"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "-", 
     RowBox[{"802", " ", 
      SubscriptBox["z", "3"], " ", 
      SubsuperscriptBox["z", "5", "2"], " ", 
      SubscriptBox["\[Theta]", "5"]}], "+", 
     RowBox[{"534", " ", 
      SubscriptBox["z", "4"], " ", 
      SubsuperscriptBox["z", "5", "2"], " ", 
      SubscriptBox["\[Theta]", "5"]}]}], ")"}]}]}]], "Input",
 CellChangeTimes->{
  3.805703598619446*^9},ExpressionUUID->"8291db57-884c-4799-a271-\
3bc0a3ffaf82"],

Cell["Corresponding Inhomogeneity", "Text",
 CellChangeTimes->{{3.805698576477152*^9, 
  3.805698588439147*^9}},ExpressionUUID->"2995f8fd-27bc-47d9-b2d8-\
e5031af97885"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{
      RowBox[{"-", "42"}], " ", 
      SubscriptBox["z", "1"]}], "+", 
     RowBox[{"168", " ", 
      SubscriptBox["z", "2"]}], "-", 
     RowBox[{"101", " ", 
      SubscriptBox["z", "3"]}], "+", 
     RowBox[{"282", " ", 
      SubscriptBox["z", "4"]}], "-", 
     RowBox[{"139", " ", 
      SubscriptBox["z", "5"]}]}], ")"}], 
   RowBox[{"Log", "[", 
    SubscriptBox["z", "1"], "]"}], 
   RowBox[{"Log", "[", 
    SubscriptBox["z", "2"], "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "416"}], "-", 
     RowBox[{"556", " ", 
      SubscriptBox["z", "1"]}], "+", 
     RowBox[{"283", " ", 
      SubscriptBox["z", "2"]}], "+", 
     RowBox[{"105", " ", 
      SubscriptBox["z", "3"]}], "-", 
     RowBox[{"15", " ", 
      SubscriptBox["z", "4"]}], "-", 
     RowBox[{"128", " ", 
      SubscriptBox["z", "5"]}]}], ")"}], 
   RowBox[{"Log", "[", 
    SubscriptBox["z", "1"], "]"}], 
   RowBox[{"Log", "[", 
    SubscriptBox["z", "3"], "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "180"}], "-", 
     RowBox[{"180", " ", 
      SubscriptBox["z", "1"]}], "-", 
     RowBox[{"345", " ", 
      SubscriptBox["z", "2"]}], "-", 
     RowBox[{"195", " ", 
      SubscriptBox["z", "3"]}], "+", 
     RowBox[{"540", " ", 
      SubscriptBox["z", "5"]}]}], ")"}], 
   RowBox[{"Log", "[", 
    SubscriptBox["z", "1"], "]"}], 
   RowBox[{"Log", "[", 
    SubscriptBox["z", "4"], "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"596", "\[VeryThinSpace]", "+", 
     RowBox[{"778", " ", 
      SubscriptBox["z", "1"]}], "-", 
     RowBox[{"106", " ", 
      SubscriptBox["z", "2"]}], "+", 
     RowBox[{"191", " ", 
      SubscriptBox["z", "3"]}], "-", 
     RowBox[{"267", " ", 
      SubscriptBox["z", "4"]}], "-", 
     RowBox[{"273", " ", 
      SubscriptBox["z", "5"]}]}], ")"}], 
   RowBox[{"Log", "[", 
    SubscriptBox["z", "1"], "]"}], 
   RowBox[{"Log", "[", 
    SubscriptBox["z", "5"], "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "13"}], "+", 
     RowBox[{"533", " ", 
      SubscriptBox["z", "1"]}], "+", 
     RowBox[{"203", 
      SubscriptBox["z", "2"]}], "-", 
     RowBox[{"21", " ", 
      SubscriptBox["z", "3"]}], "-", 
     RowBox[{"15", " ", 
      SubscriptBox["z", "4"]}], "-", 
     RowBox[{"128", " ", 
      SubscriptBox["z", "5"]}]}], ")"}], 
   RowBox[{"Log", "[", 
    SubscriptBox["z", "2"], "]"}], 
   RowBox[{"Log", "[", 
    SubscriptBox["z", "3"], "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"102", "+", 
     RowBox[{"123", " ", 
      SubscriptBox["z", "1"]}], "+", 
     RowBox[{"168", " ", 
      SubscriptBox["z", "2"]}], "-", 
     RowBox[{"195", " ", 
      SubscriptBox["z", "3"]}], "-", 
     RowBox[{"6", " ", 
      SubscriptBox["z", "5"]}]}], ")"}], 
   RowBox[{"Log", "[", 
    SubscriptBox["z", "2"], "]"}], 
   RowBox[{"Log", "[", 
    SubscriptBox["z", "4"], "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "89"}], "-", 
     RowBox[{"614", " ", 
      SubscriptBox["z", "1"]}], "-", 
     RowBox[{"539", " ", 
      SubscriptBox["z", "2"]}], "+", 
     RowBox[{"317", " ", 
      SubscriptBox["z", "3"]}], "-", 
     RowBox[{"267", " ", 
      SubscriptBox["z", "4"]}], "+", 
     RowBox[{"273", " ", 
      SubscriptBox["z", "5"]}]}], ")"}], 
   RowBox[{"Log", "[", 
    SubscriptBox["z", "2"], "]"}], 
   RowBox[{"Log", "[", 
    SubscriptBox["z", "5"], "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{"507", "+", 
     RowBox[{"122", 
      SubscriptBox["z", "1"]}], "-", 
     RowBox[{"477", " ", 
      SubscriptBox["z", "2"]}], "+", 
     RowBox[{"407", " ", 
      SubscriptBox["z", "3"]}], "-", 
     RowBox[{"252", " ", 
      SubscriptBox["z", "4"]}], "-", 
     RowBox[{"139", " ", 
      SubscriptBox["z", "5"]}]}], ")"}], 
   RowBox[{"Log", "[", 
    SubscriptBox["z", "3"], "]"}], 
   RowBox[{"Log", "[", 
    SubscriptBox["z", "4"], "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "78"}], "-", 
     RowBox[{"99", " ", 
      SubscriptBox["z", "1"]}], "-", 
     RowBox[{"9", " ", 
      SubscriptBox["z", "2"]}], "-", 
     RowBox[{"491", " ", 
      SubscriptBox["z", "3"]}], "+", 
     RowBox[{"282", " ", 
      SubscriptBox["z", "4"]}], "+", 
     RowBox[{"395", " ", 
      SubscriptBox["z", "5"]}]}], ")"}], 
   RowBox[{"Log", "[", 
    SubscriptBox["z", "3"], "]"}], 
   RowBox[{"Log", "[", 
    SubscriptBox["z", "5"], "]"}]}], "+", 
  RowBox[{
   RowBox[{"(", 
    RowBox[{
     RowBox[{"-", "429"}], "-", 
     RowBox[{"65", " ", 
      SubscriptBox["z", "1"]}], "+", 
     RowBox[{"654", " ", 
      SubscriptBox["z", "2"]}], "-", 
     RowBox[{"17", 
      SubscriptBox["z", "3"]}], "+", 
     RowBox[{"252", " ", 
      SubscriptBox["z", "4"]}], "-", 
     RowBox[{"395", " ", 
      SubscriptBox["z", "5"]}]}], ")"}], 
   RowBox[{"Log", "[", 
    SubscriptBox["z", "4"], "]"}], 
   RowBox[{"Log", "[", 
    SubscriptBox["z", "5"], "]"}]}]}]], "Input",
 CellChangeTimes->{{3.805699014334144*^9, 3.8056990170000877`*^9}, {
   3.805703214243043*^9, 3.8057032264135942`*^9}, {3.805703261087371*^9, 
   3.805703265891156*^9}, {3.805703315426671*^9, 3.805703323852167*^9}, 
   3.8057036245517073`*^9},ExpressionUUID->"c4d9bd04-2903-4d90-a6e9-\
fbc5b2e5e46a"]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
l- Loop Banana Non - Equal Mass Homogeneous Differential Operator\
\>", "Chapter",
 CellChangeTimes->{{3.805697023549979*^9, 3.8056970273107452`*^9}, {
  3.8056974210561457`*^9, 
  3.805697449193077*^9}},ExpressionUUID->"c70f4d16-c9be-4db8-a61f-\
1a1ab683e4be"],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"HomOplLoop", "[", 
    RowBox[{"loop_", ",", "var_"}], "]"}], ":=", 
   RowBox[{
    SuperscriptBox[
     SubscriptBox["\[Theta]", "var"], "2"], "-", 
    RowBox[{
     SubscriptBox["z", "var"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sum", "[", 
        RowBox[{
         SubscriptBox["\[Theta]", "k"], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", 
           RowBox[{"loop", "+", "1"}]}], "}"}]}], "]"}], "-", 
       RowBox[{"2", 
        SubscriptBox["\[Theta]", "var"]}]}], ")"}], 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"Sum", "[", 
        RowBox[{
         SubscriptBox["\[Theta]", "k"], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", 
           RowBox[{"loop", "+", "1"}]}], "}"}]}], "]"}]}], ")"}]}], "-", 
    RowBox[{
     SubscriptBox["z", "var"], 
     RowBox[{"(", 
      RowBox[{
       RowBox[{"Sum", "[", 
        RowBox[{
         SubscriptBox["z", "k"], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", 
           RowBox[{"loop", "+", "1"}]}], "}"}]}], "]"}], "-", 
       SubscriptBox["z", "var"]}], ")"}], 
     RowBox[{"(", 
      RowBox[{"1", "+", 
       RowBox[{"Sum", "[", 
        RowBox[{
         SubscriptBox["\[Theta]", "k"], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", 
           RowBox[{"loop", "+", "1"}]}], "}"}]}], "]"}]}], ")"}], 
     RowBox[{"(", 
      RowBox[{"2", "+", 
       RowBox[{"Sum", "[", 
        RowBox[{
         SubscriptBox["\[Theta]", "k"], ",", 
         RowBox[{"{", 
          RowBox[{"k", ",", 
           RowBox[{"loop", "+", "1"}]}], "}"}]}], "]"}]}], ")"}]}]}]}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.805698065526417*^9, 3.8056981834176207`*^9}, {
  3.805698309455385*^9, 3.805698323852538*^9}},
 CellLabel->
  "In[2689]:=",ExpressionUUID->"7503add6-a39e-4fd0-a7c5-189ad95481c8"],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{
  3.805698185503154*^9},ExpressionUUID->"3845a4b0-ffd1-4c93-82d9-\
bbd161cac05c"],

Cell["\<\
HomOplLoop[l,k] gives the kth homogeneous operator in the l-loop case. For \
the l-loop case there are l+1 of these operators.\
\>", "Text",
 CellChangeTimes->{{3.805698188579361*^9, 3.805698242838667*^9}, {
  3.8056983512130423`*^9, 
  3.805698367266491*^9}},ExpressionUUID->"92dec25f-52c1-4902-90e8-\
013f81954726"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"HomOplLoop", "[", 
  RowBox[{"5", ",", "3"}], "]"}]], "Input",
 CellChangeTimes->{{3.805698244696035*^9, 3.805698251231841*^9}},
 CellLabel->
  "In[2690]:=",ExpressionUUID->"9a26d4d7-eb5c-46f1-8cb5-30a1fed42078"],

Cell[BoxData[
 RowBox[{
  SubsuperscriptBox["\[Theta]", "3", "2"], "-", 
  RowBox[{
   SubscriptBox["z", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "-", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"], "+", 
     SubscriptBox["\[Theta]", "5"], "+", 
     SubscriptBox["\[Theta]", "6"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"], "+", 
     SubscriptBox["\[Theta]", "5"], "+", 
     SubscriptBox["\[Theta]", "6"]}], ")"}]}], "-", 
  RowBox[{
   SubscriptBox["z", "3"], " ", 
   RowBox[{"(", 
    RowBox[{
     SubscriptBox["z", "1"], "+", 
     SubscriptBox["z", "2"], "+", 
     SubscriptBox["z", "4"], "+", 
     SubscriptBox["z", "5"], "+", 
     SubscriptBox["z", "6"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"1", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"], "+", 
     SubscriptBox["\[Theta]", "5"], "+", 
     SubscriptBox["\[Theta]", "6"]}], ")"}], " ", 
   RowBox[{"(", 
    RowBox[{"2", "+", 
     SubscriptBox["\[Theta]", "1"], "+", 
     SubscriptBox["\[Theta]", "2"], "+", 
     SubscriptBox["\[Theta]", "3"], "+", 
     SubscriptBox["\[Theta]", "4"], "+", 
     SubscriptBox["\[Theta]", "5"], "+", 
     SubscriptBox["\[Theta]", "6"]}], ")"}]}]}]], "Output",
 CellChangeTimes->{3.805698251981883*^9, 3.8056983259256144`*^9},
 CellLabel->
  "Out[2690]=",ExpressionUUID->"0dfdb442-7669-456c-b8a7-78074e48f83e"]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.805698614791246*^9, 
  3.805698614917492*^9}},ExpressionUUID->"648a3ad5-a6a6-4efc-ba2a-\
7b007cd4df39"]
}, Closed]]
}, Open  ]]
},
WindowSize->{1277, 1282},
WindowMargins->{{Automatic, 357}, {Automatic, 0}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 164, 3, 98, "Title",ExpressionUUID->"7888f489-cae6-43e0-8513-38c113cc070b"],
Cell[CellGroupData[{
Cell[769, 29, 180, 3, 69, "Chapter",ExpressionUUID->"9ce23d2b-debd-491c-a3d5-7fe6dd1307b3"],
Cell[952, 34, 5279, 146, 462, "Input",ExpressionUUID->"519c90cb-3db6-4cf6-96ec-ff3ee8c3f80d"],
Cell[6234, 182, 147, 3, 52, "Input",ExpressionUUID->"6935a0df-c193-4737-b90b-6d1ec7269a98"],
Cell[6384, 187, 263, 6, 35, "Text",ExpressionUUID->"65703c52-355b-43b4-ab7a-cd686257340b"],
Cell[CellGroupData[{
Cell[6672, 197, 262, 6, 30, "Input",ExpressionUUID->"78015ec6-a15d-4677-b8ae-d3cf75a7b012"],
Cell[6937, 205, 1184, 39, 37, "Output",ExpressionUUID->"95bea629-39e5-4664-b677-889c7e1de93f"]
}, Open  ]],
Cell[8136, 247, 149, 3, 52, "Input",ExpressionUUID->"45cc5dfd-05ca-4417-85f7-15fc49bcaf2d"],
Cell[8288, 252, 177, 3, 35, "Text",ExpressionUUID->"bf9f8182-e047-4d1a-8df6-d369dcaaa1d9"],
Cell[CellGroupData[{
Cell[8490, 259, 396, 11, 44, "Input",ExpressionUUID->"7c9832c0-a5ee-49a4-abf0-b213c684077e"],
Cell[8889, 272, 151971, 3809, 474, "Output",ExpressionUUID->"fa134b84-3b2e-468b-b2d7-0fb55f8f20bc"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[160909, 4087, 198, 3, 58, "Chapter",ExpressionUUID->"c81a392a-e878-42b7-a0a4-12e6f59e910c"],
Cell[161110, 4092, 167, 3, 35, "Text",ExpressionUUID->"a225101e-4358-4ff9-a49f-4480ff700161"],
Cell[161280, 4097, 3059, 94, 74, "Input",ExpressionUUID->"c1aa36ff-d78e-463b-ad9b-2c90884f46e5"],
Cell[164342, 4193, 147, 3, 52, "Input",ExpressionUUID->"c39f05a7-14b0-457c-b631-b4f7e9333d27"],
Cell[164492, 4198, 179, 3, 35, "Text",ExpressionUUID->"b0da2851-75ac-4964-b555-319b9554275c"],
Cell[164674, 4203, 1092, 35, 30, "Input",ExpressionUUID->"42cf56c7-b4a1-49ed-a249-3874a248747e"],
Cell[165769, 4240, 169, 3, 35, "Text",ExpressionUUID->"ddcec24a-9d3e-4537-a18f-aad64c381781"],
Cell[165941, 4245, 303, 9, 44, "Input",ExpressionUUID->"a31f1ea7-96ec-43a7-b9c0-706e51774a5c"],
Cell[166247, 4256, 179, 3, 35, "Text",ExpressionUUID->"e40ca34d-aa34-49db-a4ff-97aaec15ebb8"],
Cell[166429, 4261, 1091, 35, 30, "Input",ExpressionUUID->"f7f451d8-5183-444e-9971-eac1985b2a73"],
Cell[167523, 4298, 169, 3, 35, "Text",ExpressionUUID->"728c1050-58a4-4aca-8ba4-767ded27c619"],
Cell[167695, 4303, 232, 7, 44, "Input",ExpressionUUID->"a9cbfb73-c96d-46b0-8cf2-a77cd77eb061"]
}, Closed]],
Cell[CellGroupData[{
Cell[167964, 4315, 206, 3, 58, "Chapter",ExpressionUUID->"885149db-9093-45d2-97b9-e272eb3da75c"],
Cell[168173, 4320, 163, 3, 35, "Text",ExpressionUUID->"8cb0f846-9ea4-4392-bd4e-af710ae8c2fe"],
Cell[168339, 4325, 4840, 144, 95, "Input",ExpressionUUID->"21bf6cfa-cbc6-4d11-92cd-ba9aa7a0e8c6"],
Cell[173182, 4471, 147, 3, 52, "Input",ExpressionUUID->"ea286b26-4dbf-4e51-b1c6-fef3533513ba"],
Cell[173332, 4476, 179, 3, 35, "Text",ExpressionUUID->"3694dcc2-822a-4889-b637-290956c1bf4c"],
Cell[173514, 4481, 7258, 211, 119, "Input",ExpressionUUID->"0c292332-5440-4480-afc6-cb310e5d8c83"],
Cell[180775, 4694, 169, 3, 35, "Text",ExpressionUUID->"885ed052-3b3e-4cc1-a30e-1dfce8723feb"],
Cell[180947, 4699, 479, 12, 44, "Input",ExpressionUUID->"8c4dfd46-f512-4b10-9a8d-4527c6f1e7a8"],
Cell[181429, 4713, 179, 3, 35, "Text",ExpressionUUID->"30a92257-0afa-40a0-9ed1-52bb7adc1f09"],
Cell[181611, 4718, 5915, 179, 94, "Input",ExpressionUUID->"76dd2063-48bd-471c-b796-006f00518e6b"],
Cell[187529, 4899, 169, 3, 35, "Text",ExpressionUUID->"1ba86d85-3757-4d42-835f-4b79408de474"],
Cell[187701, 4904, 624, 16, 44, "Input",ExpressionUUID->"2dc2303d-cc2b-4bd4-9603-62a091db59ae"],
Cell[188328, 4922, 179, 3, 35, "Text",ExpressionUUID->"52410f5a-e190-4374-beeb-bd286a0802e2"],
Cell[188510, 4927, 8632, 253, 162, "Input",ExpressionUUID->"e09ef6be-f445-487d-ae29-73c5896db44c"],
Cell[197145, 5182, 169, 3, 35, "Text",ExpressionUUID->"0648d9fc-6841-4298-a0cc-92f17e9bf618"],
Cell[197317, 5187, 452, 12, 44, "Input",ExpressionUUID->"998ca03f-9f46-4645-804f-b2742bf27609"]
}, Closed]],
Cell[CellGroupData[{
Cell[197806, 5204, 256, 4, 58, "Chapter",ExpressionUUID->"467a2f02-2ef3-4904-86d7-64bbb774f9c7"],
Cell[198065, 5210, 163, 3, 35, "Text",ExpressionUUID->"ad2738a3-8420-4e22-be2e-a6826af37d32"],
Cell[198231, 5215, 7029, 204, 116, "Input",ExpressionUUID->"3fa1e548-ce6d-4cb1-a1e9-21e087632de4"],
Cell[205263, 5421, 147, 3, 52, "Input",ExpressionUUID->"58f47a24-1ee3-4486-a866-ebcb3ed10058"],
Cell[205413, 5426, 179, 3, 35, "Text",ExpressionUUID->"62c8bda0-9e7b-4dd5-9b71-26d7cb025bea"],
Cell[205595, 5431, 73597, 2078, 1086, "Input",ExpressionUUID->"8291db57-884c-4799-a271-3bc0a3ffaf82"],
Cell[279195, 7511, 169, 3, 35, "Text",ExpressionUUID->"2995f8fd-27bc-47d9-b2d8-e5031af97885"],
Cell[279367, 7516, 5369, 179, 188, "Input",ExpressionUUID->"c4d9bd04-2903-4d90-a6e9-fbc5b2e5e46a"]
}, Closed]],
Cell[CellGroupData[{
Cell[284773, 7700, 271, 6, 58, "Chapter",ExpressionUUID->"c70f4d16-c9be-4db8-a61f-1a1ab683e4be"],
Cell[285047, 7708, 1872, 59, 80, "Input",ExpressionUUID->"7503add6-a39e-4fd0-a7c5-189ad95481c8"],
Cell[286922, 7769, 147, 3, 52, "Input",ExpressionUUID->"3845a4b0-ffd1-4c93-82d9-bbd161cac05c"],
Cell[287072, 7774, 327, 7, 35, "Text",ExpressionUUID->"92dec25f-52c1-4902-90e8-013f81954726"],
Cell[CellGroupData[{
Cell[287424, 7785, 236, 5, 30, "Input",ExpressionUUID->"9a26d4d7-eb5c-46f1-8cb5-30a1fed42078"],
Cell[287663, 7792, 1729, 48, 36, "Output",ExpressionUUID->"0dfdb442-7669-456c-b8a7-78074e48f83e"]
}, Open  ]],
Cell[289407, 7843, 206, 4, 73, "Input",ExpressionUUID->"648a3ad5-a6a6-4efc-ba2a-7b007cd4df39"]
}, Closed]]
}, Open  ]]
}
]
*)

